/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.BdioObject;
import com.blackducksoftware.common.base.ExtraOptionals;
import com.blackducksoftware.common.base.ExtraStrings;
import com.blackducksoftware.common.value.ProductList;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class BdioMetadata
extends BdioObject {
    private Optional<Throwable> throwable = Optional.empty();

    public BdioMetadata() {
        this((Map<String, Object>)ImmutableMap.of());
    }

    public BdioMetadata(Map<String, Object> other) {
        super(other);
    }

    public BdioMetadata(Throwable error) {
        this();
        this.throwable = Optional.of(error);
    }

    public static BdioMetadata createRandomUUID() {
        return new BdioMetadata().id(BdioMetadata.randomId());
    }

    public Optional<Throwable> getThrowable() {
        return this.throwable;
    }

    public Map<String, Object> asNamedGraph(Object graph, String ... keys) {
        Objects.requireNonNull(graph);
        LinkedHashMap<String, Object> namedGraph = new LinkedHashMap<String, Object>(this);
        if (keys.length > 0) {
            namedGraph.keySet().retainAll(Arrays.asList(keys));
        }
        namedGraph.put("@graph", graph);
        return namedGraph;
    }

    public Map<String, Object> asNamedGraph() {
        return this.asNamedGraph(new ArrayList(0), new String[0]);
    }

    public BdioMetadata merge(Map<String, Object> other) {
        if (other instanceof BdioMetadata) {
            this.throwable = ExtraOptionals.merge(this.throwable, ((BdioMetadata)other).throwable, (a, b) -> {
                a.addSuppressed((Throwable)b);
                return a;
            });
        }
        other.forEach((key, value) -> {
            if (key.equals("@id")) {
                Preconditions.checkArgument((boolean)(value instanceof String), (Object)"identifier must be mapped to a string");
                if (this.id() == null) {
                    this.id((String)value);
                    return;
                } else {
                    if (!ExtraStrings.beforeLast((CharSequence)((String)value), (char)'#').equals(this.id())) throw new IllegalArgumentException("identifier mismatch: " + value + " (was expecting " + this.id() + ")");
                    if (value.equals(this.get("@id"))) return;
                    this.id(ExtraStrings.beforeLast((CharSequence)((String)value), (char)'#'));
                }
                return;
            } else if (key.equals(Bdio.DataProperty.publisher.toString())) {
                Object publisher = this.get(key);
                if (publisher != null) {
                    ProductList.Builder builder = new ProductList.Builder();
                    ProductList.from((Object)this.fromFieldValue((String)key, publisher)).forEach(arg_0 -> ((ProductList.Builder)builder).mergeProduct(arg_0));
                    ProductList.from((Object)this.fromFieldValue((String)key, value)).forEach(arg_0 -> ((ProductList.Builder)builder).mergeProduct(arg_0));
                    this.putFieldValue((Object)Bdio.DataProperty.publisher, builder.build());
                    return;
                } else {
                    this.put((String)key, value);
                }
                return;
            } else if (key.equals(Bdio.DataProperty.creator.toString())) {
                Object creator = this.get(key);
                if (creator != null) {
                    this.put((String)key, ExtraStrings.splitOnFirst((CharSequence)this.fromFieldValue((String)key, creator).toString(), (char)'@', (user1, host1) -> (String)ExtraStrings.splitOnFirst((CharSequence)this.fromFieldValue((String)key, value).toString(), (char)'@', (user2, host2) -> ExtraStrings.ensureDelimiter((CharSequence)(Strings.isNullOrEmpty((String)user1) ? user2 : user1), (CharSequence)"@", (CharSequence)(Strings.isNullOrEmpty((String)host1) ? host2 : host1)))));
                    return;
                } else {
                    this.put((String)key, value);
                }
                return;
            } else {
                this.put((String)key, value);
            }
        });
        return this;
    }

    public BdioMetadata id(@Nullable String id) {
        this.put("@id", (Object)id);
        return this;
    }

    public BdioMetadata name(@Nullable String name) {
        this.putFieldValue((Object)Bdio.DataProperty.name, name);
        return this;
    }

    public BdioMetadata captureOptions(@Nullable List<String> captureOptions) {
        this.putFieldValue((Object)Bdio.DataProperty.captureOptions, captureOptions);
        return this;
    }

    public BdioMetadata captureInterval(@Nullable String captureInterval) {
        this.putFieldValue((Object)Bdio.DataProperty.captureInterval, captureInterval);
        return this;
    }

    public BdioMetadata captureInterval(@Nullable ZonedDateTime start, @Nullable ZonedDateTime end) {
        return this.captureInterval(start != null && end != null ? start + "/" + end : null);
    }

    public BdioMetadata creationDateTime(@Nullable ZonedDateTime creation) {
        this.putFieldValue((Object)Bdio.DataProperty.creationDateTime, creation);
        return this;
    }

    public BdioMetadata creator(@Nullable String creator) {
        this.putFieldValue((Object)Bdio.DataProperty.creator, creator);
        return this;
    }

    public BdioMetadata creator(@Nullable String user, @Nullable String host) {
        if (user != null || host != null) {
            return this.creator(Strings.nullToEmpty((String)user) + Strings.nullToEmpty((String)ExtraStrings.ensurePrefix((CharSequence)"@", (CharSequence)host)));
        }
        return this.creator(null);
    }

    public BdioMetadata platform(@Nullable ProductList platform) {
        this.putFieldValue((Object)Bdio.DataProperty.platform, platform);
        return this;
    }

    public BdioMetadata publisher(@Nullable ProductList publisher) {
        this.putFieldValue((Object)Bdio.DataProperty.publisher, publisher);
        return this;
    }

    public BdioMetadata buildDetails(@Nullable String buildDetails) {
        this.putFieldValue((Object)Bdio.DataProperty.buildDetails, buildDetails);
        return this;
    }

    public BdioMetadata buildNumber(@Nullable String buildNumber) {
        this.putFieldValue((Object)Bdio.DataProperty.buildNumber, buildNumber);
        return this;
    }

    public BdioMetadata sourceRepository(@Nullable String sourceRepository) {
        this.putFieldValue((Object)Bdio.DataProperty.sourceRepository, sourceRepository);
        return this;
    }

    public BdioMetadata sourceRevision(@Nullable String sourceRevision) {
        this.putFieldValue((Object)Bdio.DataProperty.sourceRevision, sourceRevision);
        return this;
    }

    public BdioMetadata sourceBranch(@Nullable String sourceBranch) {
        this.putFieldValue((Object)Bdio.DataProperty.sourceBranch, sourceBranch);
        return this;
    }

    public BdioMetadata sourceTag(@Nullable String sourceTag) {
        this.putFieldValue((Object)Bdio.DataProperty.sourceTag, sourceTag);
        return this;
    }
}

