/*
 * Copyright 2017 Black Duck Software, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.blackducksoftware.bdio2.model;

import java.time.ZonedDateTime;

import javax.annotation.Nullable;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.BdioObject;
import com.blackducksoftware.common.value.ProductList;

public final class Vulnerability extends BdioObject {

    public Vulnerability(String id) {
        super(id, Bdio.Class.Vulnerability);
    }

    public Vulnerability affected(@Nullable Object affected) {
        putFieldValue(Bdio.ObjectProperty.affected, affected);
        return this;
    }

    public Vulnerability canonical(@Nullable Vulnerability canonical) {
        putFieldValue(Bdio.ObjectProperty.canonical, canonical);
        return this;
    }

    public Vulnerability description(@Nullable Annotation description) {
        putFieldValue(Bdio.ObjectProperty.description, description);
        return this;
    }

    public Vulnerability name(@Nullable String name) {
        putFieldValue(Bdio.DataProperty.name, name);
        return this;
    }

    public Vulnerability namespace(@Nullable String namespace) {
        putFieldValue(Bdio.DataProperty.namespace, namespace);
        return this;
    }

    public Vulnerability creationDateTime(@Nullable ZonedDateTime creationDateTime) {
        putFieldValue(Bdio.DataProperty.creationDateTime, creationDateTime);
        return this;
    }

    public Vulnerability lastModifiedDateTime(ZonedDateTime lastModifiedDateTime) {
        putFieldValue(Bdio.DataProperty.lastModifiedDateTime, lastModifiedDateTime);
        return this;
    }

    public Vulnerability identifier(@Nullable String identifier) {
        putFieldValue(Bdio.DataProperty.identifier, identifier);
        return this;
    }

    public Vulnerability context(@Nullable String context) {
        putFieldValue(Bdio.DataProperty.context, context);
        return this;
    }

    public Vulnerability resolver(@Nullable ProductList resolver) {
        putFieldValue(Bdio.DataProperty.resolver, resolver);
        return this;
    }

    public Vulnerability platform(@Nullable ProductList platform) {
        putFieldValue(Bdio.DataProperty.platform, platform);
        return this;
    }

    public Vulnerability homepage(@Nullable String homepage) {
        putFieldValue(Bdio.DataProperty.homepage, homepage);
        return this;
    }

}
