/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.rest;

import com.bettercloud.vault.rest.RestException;
import com.bettercloud.vault.rest.RestResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class Rest {
    private static SSLContext DISABLED_SSL_CONTEXT;
    private String urlString;
    private byte[] body;
    private final Map<String, String> parameters = new TreeMap<String, String>();
    private final Map<String, String> headers = new TreeMap<String, String>();
    private Integer connectTimeoutSeconds;
    private Integer readTimeoutSeconds;
    private Boolean sslVerification;
    private SSLContext sslContext;

    public Rest url(String urlString) {
        this.urlString = urlString;
        return this;
    }

    public Rest body(byte[] body) {
        this.body = body == null ? null : Arrays.copyOf(body, body.length);
        return this;
    }

    public Rest parameter(String name, String value) throws RestException {
        try {
            this.parameters.put(URLEncoder.encode(name, "UTF-8"), URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RestException(e);
        }
        return this;
    }

    public Rest header(String name, String value) throws RestException {
        try {
            this.headers.put(URLEncoder.encode(name, "UTF-8"), URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RestException(e);
        }
        return this;
    }

    public Rest connectTimeoutSeconds(Integer connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return this;
    }

    public Rest readTimeoutSeconds(Integer readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
        return this;
    }

    public Rest sslVerification(Boolean sslVerification) {
        this.sslVerification = sslVerification;
        return this;
    }

    public Rest sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public RestResponse get() throws RestException {
        if (this.urlString == null) {
            throw new RestException("No URL is set");
        }
        try {
            if (!this.parameters.isEmpty()) {
                this.urlString = this.urlString.indexOf(63) == -1 ? this.urlString + "?" + this.parametersToQueryString() : this.urlString + "&" + this.parametersToQueryString();
            }
            URLConnection connection = this.initURLConnection(this.urlString, "GET");
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
            int statusCode = this.connectionStatus(connection);
            String mimeType = connection.getContentType();
            byte[] body = this.responseBodyBytes(connection);
            return new RestResponse(statusCode, mimeType, body);
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    public RestResponse post() throws RestException {
        return this.postOrPutImpl(true);
    }

    public RestResponse put() throws RestException {
        return this.postOrPutImpl(false);
    }

    public RestResponse delete() throws RestException {
        if (this.urlString == null) {
            throw new RestException("No URL is set");
        }
        try {
            if (!this.parameters.isEmpty()) {
                this.urlString = this.urlString.indexOf(63) == -1 ? this.urlString + "?" + this.parametersToQueryString() : this.urlString + "&" + this.parametersToQueryString();
            }
            URLConnection connection = this.initURLConnection(this.urlString, "DELETE");
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
            int statusCode = this.connectionStatus(connection);
            String mimeType = connection.getContentType();
            byte[] body = this.responseBodyBytes(connection);
            return new RestResponse(statusCode, mimeType, body);
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    private RestResponse postOrPutImpl(boolean doPost) throws RestException {
        if (this.urlString == null) {
            throw new RestException("No URL is set");
        }
        try {
            OutputStream outputStream;
            URLConnection connection = doPost ? this.initURLConnection(this.urlString, "POST") : this.initURLConnection(this.urlString, "PUT");
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
            connection.setDoOutput(true);
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            if (this.body != null) {
                outputStream = connection.getOutputStream();
                outputStream.write(this.body);
                outputStream.close();
            } else if (!this.parameters.isEmpty()) {
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                outputStream = connection.getOutputStream();
                outputStream.write(this.parametersToQueryString().getBytes("UTF-8"));
                outputStream.close();
            }
            int statusCode = this.connectionStatus(connection);
            String mimeType = connection.getContentType();
            byte[] body = this.responseBodyBytes(connection);
            return new RestResponse(statusCode, mimeType, body);
        }
        catch (IOException e) {
            throw new RestException(e);
        }
    }

    private URLConnection initURLConnection(String urlString, String method) throws RestException {
        URLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = url.openConnection();
            if (this.connectTimeoutSeconds != null) {
                connection.setConnectTimeout(this.connectTimeoutSeconds * 1000);
            }
            if (this.readTimeoutSeconds != null) {
                connection.setReadTimeout(this.readTimeoutSeconds * 1000);
            }
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection;
                if (this.sslVerification != null && !this.sslVerification.booleanValue()) {
                    httpsURLConnection.setSSLSocketFactory(DISABLED_SSL_CONTEXT.getSocketFactory());
                    httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String s, SSLSession sslSession) {
                            return true;
                        }
                    });
                } else if (this.sslContext != null) {
                    httpsURLConnection.setSSLSocketFactory(this.sslContext.getSocketFactory());
                }
                httpsURLConnection.setRequestMethod(method);
            } else if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
                httpURLConnection.setRequestMethod(method);
            } else {
                String message = "URL string " + urlString + " cannot be parsed as an instance of HttpURLConnection or HttpsURLConnection";
                throw new RestException(message);
            }
            URLConnection uRLConnection = connection;
            return uRLConnection;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
        finally {
            if (connection != null && connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    private String parametersToQueryString() {
        StringBuilder queryString = new StringBuilder();
        ArrayList<Map.Entry<String, String>> params = new ArrayList<Map.Entry<String, String>>(this.parameters.entrySet());
        for (int index = 0; index < params.size(); ++index) {
            if (index > 0) {
                queryString.append('&');
            }
            String name = (String)((Map.Entry)params.get(index)).getKey();
            String value = (String)((Map.Entry)params.get(index)).getValue();
            queryString.append(name).append('=').append(value);
        }
        return queryString.toString();
    }

    private byte[] responseBodyBytes(URLConnection connection) throws RestException {
        try {
            int bytesRead;
            InputStream inputStream;
            int responseCode = this.connectionStatus(connection);
            if (200 <= responseCode && responseCode <= 299) {
                inputStream = connection.getInputStream();
            } else if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection;
                inputStream = httpsURLConnection.getErrorStream();
            } else {
                HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
                inputStream = httpURLConnection.getErrorStream();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] bytes = new byte[16384];
            while ((bytesRead = inputStream.read(bytes, 0, bytes.length)) != -1) {
                byteArrayOutputStream.write(bytes, 0, bytesRead);
            }
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    private int connectionStatus(URLConnection connection) throws IOException, RestException {
        int statusCode;
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection;
            statusCode = httpsURLConnection.getResponseCode();
        } else if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
            statusCode = httpURLConnection.getResponseCode();
        } else {
            String className = connection != null ? connection.getClass().getName() : "null";
            throw new RestException("Expecting a URLConnection of type " + HttpURLConnection.class.getName() + " or " + HttpsURLConnection.class.getName() + ", found " + className);
        }
        return statusCode;
    }

    static {
        try {
            DISABLED_SSL_CONTEXT = SSLContext.getInstance("TLS");
            DISABLED_SSL_CONTEXT.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

