/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.response;

import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.rest.RestResponse;
import java.io.Serializable;

public class HealthResponse
implements Serializable {
    private RestResponse restResponse;
    private int retries;
    private Boolean initialized;
    private Boolean sealed;
    private Boolean standby;
    private Long serverTimeUTC;

    public HealthResponse(RestResponse restResponse, int retries) throws VaultException {
        this.restResponse = restResponse;
        this.retries = retries;
        if (restResponse == null) {
            throw new VaultException("Response is null");
        }
        if (restResponse.getBody() == null) {
            throw new VaultException("Response contains a bad payload", restResponse.getStatus());
        }
        if (restResponse.getBody().length > 0) {
            String mimeType;
            String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
            if (!mimeType.equals("application/json")) {
                throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
            }
            try {
                String jsonString = new String(restResponse.getBody(), "UTF-8");
                JsonObject jsonObject = Json.parse(jsonString).asObject();
                this.initialized = jsonObject.get("initialized") == null ? null : Boolean.valueOf(jsonObject.get("initialized").asBoolean());
                this.sealed = jsonObject.get("sealed") == null ? null : Boolean.valueOf(jsonObject.get("sealed").asBoolean());
                this.standby = jsonObject.get("standby") == null ? null : Boolean.valueOf(jsonObject.get("standby").asBoolean());
                this.serverTimeUTC = jsonObject.get("server_time_utc") == null ? null : Long.valueOf(jsonObject.get("server_time_utc").asLong());
            }
            catch (Exception e) {
                throw new VaultException("Unable to parse JSON payload: " + e, restResponse.getStatus());
            }
        }
    }

    public RestResponse getRestResponse() {
        return this.restResponse;
    }

    public int getRetries() {
        return this.retries;
    }

    public Boolean getInitialized() {
        return this.initialized;
    }

    public Boolean getSealed() {
        return this.sealed;
    }

    public Boolean getStandby() {
        return this.standby;
    }

    public Long getServerTimeUTC() {
        return this.serverTimeUTC;
    }
}

