/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.ImportSourceCredentials;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ImportSource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ImportSource.class);
    @JsonProperty(value="resourceId")
    private String resourceId;
    @JsonProperty(value="registryUri")
    private String registryUri;
    @JsonProperty(value="credentials")
    private ImportSourceCredentials credentials;
    @JsonProperty(value="sourceImage", required=true)
    private String sourceImage;

    public String resourceId() {
        return this.resourceId;
    }

    public ImportSource withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String registryUri() {
        return this.registryUri;
    }

    public ImportSource withRegistryUri(String registryUri) {
        this.registryUri = registryUri;
        return this;
    }

    public ImportSourceCredentials credentials() {
        return this.credentials;
    }

    public ImportSource withCredentials(ImportSourceCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public String sourceImage() {
        return this.sourceImage;
    }

    public ImportSource withSourceImage(String sourceImage) {
        this.sourceImage = sourceImage;
        return this;
    }

    public void validate() {
        if (this.credentials() != null) {
            this.credentials().validate();
        }
        if (this.sourceImage() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sourceImage in model ImportSource"));
        }
    }
}

