/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.ImportMode;
import com.azure.resourcemanager.containerregistry.models.ImportSource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ImportImageParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ImportImageParameters.class);
    @JsonProperty(value="source", required=true)
    private ImportSource source;
    @JsonProperty(value="targetTags")
    private List<String> targetTags;
    @JsonProperty(value="untaggedTargetRepositories")
    private List<String> untaggedTargetRepositories;
    @JsonProperty(value="mode")
    private ImportMode mode;

    public ImportSource source() {
        return this.source;
    }

    public ImportImageParameters withSource(ImportSource source) {
        this.source = source;
        return this;
    }

    public List<String> targetTags() {
        return this.targetTags;
    }

    public ImportImageParameters withTargetTags(List<String> targetTags) {
        this.targetTags = targetTags;
        return this;
    }

    public List<String> untaggedTargetRepositories() {
        return this.untaggedTargetRepositories;
    }

    public ImportImageParameters withUntaggedTargetRepositories(List<String> untaggedTargetRepositories) {
        this.untaggedTargetRepositories = untaggedTargetRepositories;
        return this;
    }

    public ImportMode mode() {
        return this.mode;
    }

    public ImportImageParameters withMode(ImportMode mode) {
        this.mode = mode;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property source in model ImportImageParameters"));
        }
        this.source().validate();
    }
}

