/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.ResourceIdentityType;
import com.azure.resourcemanager.containerregistry.models.UserIdentityProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class IdentityProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(IdentityProperties.class);
    @JsonProperty(value="principalId")
    private String principalId;
    @JsonProperty(value="tenantId")
    private String tenantId;
    @JsonProperty(value="type")
    private ResourceIdentityType type;
    @JsonProperty(value="userAssignedIdentities")
    private Map<String, UserIdentityProperties> userAssignedIdentities;

    public String principalId() {
        return this.principalId;
    }

    public IdentityProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public IdentityProperties withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public ResourceIdentityType type() {
        return this.type;
    }

    public IdentityProperties withType(ResourceIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, UserIdentityProperties> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public IdentityProperties withUserAssignedIdentities(Map<String, UserIdentityProperties> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

