/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.Credentials;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.TaskStatus;
import com.azure.resourcemanager.containerregistry.models.TaskStepProperties;
import com.azure.resourcemanager.containerregistry.models.TriggerProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

@JsonFlatten
public class TaskInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TaskInner.class);
    @JsonProperty(value="identity")
    private IdentityProperties identity;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.creationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;
    @JsonProperty(value="properties.status")
    private TaskStatus status;
    @JsonProperty(value="properties.platform")
    private PlatformProperties platform;
    @JsonProperty(value="properties.agentConfiguration")
    private AgentProperties agentConfiguration;
    @JsonProperty(value="properties.timeout")
    private Integer timeout;
    @JsonProperty(value="properties.step")
    private TaskStepProperties step;
    @JsonProperty(value="properties.trigger")
    private TriggerProperties trigger;
    @JsonProperty(value="properties.credentials")
    private Credentials credentials;

    public IdentityProperties identity() {
        return this.identity;
    }

    public TaskInner withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public TaskStatus status() {
        return this.status;
    }

    public TaskInner withStatus(TaskStatus status) {
        this.status = status;
        return this;
    }

    public PlatformProperties platform() {
        return this.platform;
    }

    public TaskInner withPlatform(PlatformProperties platform) {
        this.platform = platform;
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.agentConfiguration;
    }

    public TaskInner withAgentConfiguration(AgentProperties agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public TaskInner withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public TaskStepProperties step() {
        return this.step;
    }

    public TaskInner withStep(TaskStepProperties step) {
        this.step = step;
        return this;
    }

    public TriggerProperties trigger() {
        return this.trigger;
    }

    public TaskInner withTrigger(TriggerProperties trigger) {
        this.trigger = trigger;
        return this;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public TaskInner withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.platform() != null) {
            this.platform().validate();
        }
        if (this.agentConfiguration() != null) {
            this.agentConfiguration().validate();
        }
        if (this.step() != null) {
            this.step().validate();
        }
        if (this.trigger() != null) {
            this.trigger().validate();
        }
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }
}

