// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Deployment resource properties payload. */
@Fluent
public final class DeploymentResourceProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DeploymentResourceProperties.class);

    /*
     * Uploaded source information of the deployment.
     */
    @JsonProperty(value = "source")
    private UserSourceInfo source;

    /*
     * App name of the deployment
     */
    @JsonProperty(value = "appName", access = JsonProperty.Access.WRITE_ONLY)
    private String appName;

    /*
     * Deployment settings of the Deployment
     */
    @JsonProperty(value = "deploymentSettings")
    private DeploymentSettings deploymentSettings;

    /*
     * Provisioning state of the Deployment
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private DeploymentResourceProvisioningState provisioningState;

    /*
     * Status of the Deployment
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private DeploymentResourceStatus status;

    /*
     * Indicates whether the Deployment is active
     */
    @JsonProperty(value = "active", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean active;

    /*
     * Date time when the resource is created
     */
    @JsonProperty(value = "createdTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdTime;

    /*
     * Collection of instances belong to the Deployment
     */
    @JsonProperty(value = "instances", access = JsonProperty.Access.WRITE_ONLY)
    private List<DeploymentInstance> instances;

    /**
     * Get the source property: Uploaded source information of the deployment.
     *
     * @return the source value.
     */
    public UserSourceInfo source() {
        return this.source;
    }

    /**
     * Set the source property: Uploaded source information of the deployment.
     *
     * @param source the source value to set.
     * @return the DeploymentResourceProperties object itself.
     */
    public DeploymentResourceProperties withSource(UserSourceInfo source) {
        this.source = source;
        return this;
    }

    /**
     * Get the appName property: App name of the deployment.
     *
     * @return the appName value.
     */
    public String appName() {
        return this.appName;
    }

    /**
     * Get the deploymentSettings property: Deployment settings of the Deployment.
     *
     * @return the deploymentSettings value.
     */
    public DeploymentSettings deploymentSettings() {
        return this.deploymentSettings;
    }

    /**
     * Set the deploymentSettings property: Deployment settings of the Deployment.
     *
     * @param deploymentSettings the deploymentSettings value to set.
     * @return the DeploymentResourceProperties object itself.
     */
    public DeploymentResourceProperties withDeploymentSettings(DeploymentSettings deploymentSettings) {
        this.deploymentSettings = deploymentSettings;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the Deployment.
     *
     * @return the provisioningState value.
     */
    public DeploymentResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the status property: Status of the Deployment.
     *
     * @return the status value.
     */
    public DeploymentResourceStatus status() {
        return this.status;
    }

    /**
     * Get the active property: Indicates whether the Deployment is active.
     *
     * @return the active value.
     */
    public Boolean active() {
        return this.active;
    }

    /**
     * Get the createdTime property: Date time when the resource is created.
     *
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    /**
     * Get the instances property: Collection of instances belong to the Deployment.
     *
     * @return the instances value.
     */
    public List<DeploymentInstance> instances() {
        return this.instances;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (source() != null) {
            source().validate();
        }
        if (deploymentSettings() != null) {
            deploymentSettings().validate();
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
    }
}
