// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Custom domain of app resource payload. */
@Fluent
public final class CustomDomainProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CustomDomainProperties.class);

    /*
     * The thumbprint of bound certificate.
     */
    @JsonProperty(value = "thumbprint")
    private String thumbprint;

    /*
     * The app name of domain.
     */
    @JsonProperty(value = "appName", access = JsonProperty.Access.WRITE_ONLY)
    private String appName;

    /*
     * The bound certificate name of domain.
     */
    @JsonProperty(value = "certName")
    private String certName;

    /**
     * Get the thumbprint property: The thumbprint of bound certificate.
     *
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Set the thumbprint property: The thumbprint of bound certificate.
     *
     * @param thumbprint the thumbprint value to set.
     * @return the CustomDomainProperties object itself.
     */
    public CustomDomainProperties withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    /**
     * Get the appName property: The app name of domain.
     *
     * @return the appName value.
     */
    public String appName() {
        return this.appName;
    }

    /**
     * Get the certName property: The bound certificate name of domain.
     *
     * @return the certName value.
     */
    public String certName() {
        return this.certName;
    }

    /**
     * Set the certName property: The bound certificate name of domain.
     *
     * @param certName the certName value to set.
     * @return the CustomDomainProperties object itself.
     */
    public CustomDomainProperties withCertName(String certName) {
        this.certName = certName;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
