// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Error record of the config server settings. */
@Fluent
public final class ConfigServerSettingsErrorRecord {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ConfigServerSettingsErrorRecord.class);

    /*
     * The name of the config server settings error record
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The uri of the config server settings error record
     */
    @JsonProperty(value = "uri")
    private String uri;

    /*
     * The detail error messages of the record
     */
    @JsonProperty(value = "messages")
    private List<String> messages;

    /**
     * Get the name property: The name of the config server settings error record.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the config server settings error record.
     *
     * @param name the name value to set.
     * @return the ConfigServerSettingsErrorRecord object itself.
     */
    public ConfigServerSettingsErrorRecord withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the uri property: The uri of the config server settings error record.
     *
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: The uri of the config server settings error record.
     *
     * @param uri the uri value to set.
     * @return the ConfigServerSettingsErrorRecord object itself.
     */
    public ConfigServerSettingsErrorRecord withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the messages property: The detail error messages of the record.
     *
     * @return the messages value.
     */
    public List<String> messages() {
        return this.messages;
    }

    /**
     * Set the messages property: The detail error messages of the record.
     *
     * @param messages the messages value to set.
     * @return the ConfigServerSettingsErrorRecord object itself.
     */
    public ConfigServerSettingsErrorRecord withMessages(List<String> messages) {
        this.messages = messages;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
