// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appplatform.models.MonitoringSettingProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Monitoring Setting resource. */
@Fluent
public final class MonitoringSettingResourceInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MonitoringSettingResourceInner.class);

    /*
     * Properties of the Monitoring Setting resource
     */
    @JsonProperty(value = "properties")
    private MonitoringSettingProperties properties;

    /**
     * Get the properties property: Properties of the Monitoring Setting resource.
     *
     * @return the properties value.
     */
    public MonitoringSettingProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the Monitoring Setting resource.
     *
     * @param properties the properties value to set.
     * @return the MonitoringSettingResourceInner object itself.
     */
    public MonitoringSettingResourceInner withProperties(MonitoringSettingProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
