// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appplatform.models.CertificateProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Certificate resource payload. */
@Fluent
public final class CertificateResourceInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CertificateResourceInner.class);

    /*
     * Properties of the certificate resource payload.
     */
    @JsonProperty(value = "properties")
    private CertificateProperties properties;

    /**
     * Get the properties property: Properties of the certificate resource payload.
     *
     * @return the properties value.
     */
    public CertificateProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the certificate resource payload.
     *
     * @param properties the properties value to set.
     * @return the CertificateResourceInner object itself.
     */
    public CertificateResourceInner withProperties(CertificateProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
