/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.Algorithm;
import com.azure.security.keyvault.keys.cryptography.AlgorithmResolver;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceClient;
import com.azure.security.keyvault.keys.cryptography.ICryptoTransform;
import com.azure.security.keyvault.keys.cryptography.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.LocalKeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import java.security.NoSuchAlgorithmException;
import reactor.core.publisher.Mono;

class SymmetricKeyCryptographyClient
extends LocalKeyCryptographyClient {
    private final ClientLogger logger = new ClientLogger(SymmetricKeyCryptographyClient.class);
    private byte[] key;

    SymmetricKeyCryptographyClient(CryptographyServiceClient serviceClient) {
        super(serviceClient);
    }

    SymmetricKeyCryptographyClient(JsonWebKey key, CryptographyServiceClient serviceClient) {
        super(serviceClient);
        this.key = key.toAes().getEncoded();
    }

    private byte[] getKey(JsonWebKey key) {
        if (this.key == null) {
            this.key = key.toAes().getEncoded();
        }
        return this.key;
    }

    @Override
    Mono<EncryptResult> encryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, Context context, JsonWebKey jsonWebKey) {
        return Mono.error((Throwable)new UnsupportedOperationException("encrypt operation not supported for AES/OCT/Symmetric key"));
    }

    @Override
    Mono<DecryptResult> decryptAsync(EncryptionAlgorithm algorithm, byte[] cipherText, Context context, JsonWebKey jsonWebKey) {
        return Mono.error((Throwable)new UnsupportedOperationException("decrypt operation not supported for AES/OCT/Symmetric key"));
    }

    @Override
    Mono<SignResult> signAsync(SignatureAlgorithm algorithm, byte[] digest, Context context, JsonWebKey key) {
        return Mono.error((Throwable)new UnsupportedOperationException("Sign operation not supported for OCT/Symmetric key"));
    }

    @Override
    Mono<VerifyResult> verifyAsync(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context, JsonWebKey key) {
        return Mono.error((Throwable)new UnsupportedOperationException("Verify operation not supported for OCT/Symmetric key"));
    }

    @Override
    Mono<WrapResult> wrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] key, Context context, JsonWebKey jsonWebKey) {
        this.key = this.getKey(jsonWebKey);
        if (key == null || key.length == 0) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("key"));
        }
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null || !(baseAlgorithm instanceof LocalKeyWrapAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        LocalKeyWrapAlgorithm algo = (LocalKeyWrapAlgorithm)baseAlgorithm;
        ICryptoTransform transform = null;
        try {
            transform = algo.createEncryptor(this.key, null, null);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        byte[] encrypted = null;
        try {
            encrypted = transform.doFinal(key);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        return Mono.just((Object)new WrapResult(encrypted, algorithm, jsonWebKey.getId()));
    }

    @Override
    Mono<UnwrapResult> unwrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context, JsonWebKey jsonWebKey) {
        byte[] decrypted;
        ICryptoTransform transform;
        this.key = this.getKey(jsonWebKey);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null || !(baseAlgorithm instanceof LocalKeyWrapAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        LocalKeyWrapAlgorithm algo = (LocalKeyWrapAlgorithm)baseAlgorithm;
        try {
            transform = algo.createDecryptor(this.key, null, null);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        try {
            decrypted = transform.doFinal(encryptedKey);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        return Mono.just((Object)new UnwrapResult(decrypted, algorithm, jsonWebKey.getId()));
    }

    @Override
    Mono<SignResult> signDataAsync(SignatureAlgorithm algorithm, byte[] data, Context context, JsonWebKey key) {
        return this.signAsync(algorithm, data, context, key);
    }

    @Override
    Mono<VerifyResult> verifyDataAsync(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context, JsonWebKey key) {
        return this.verifyAsync(algorithm, data, signature, context, key);
    }
}

