/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.util.Base64Url;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.fasterxml.jackson.annotation.JsonProperty;

class KeyOperationParameters {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    @JsonProperty(value="alg", required=true)
    private EncryptionAlgorithm algorithm;
    @JsonProperty(value="value", required=true)
    private Base64Url value;

    KeyOperationParameters() {
    }

    public EncryptionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public KeyOperationParameters setAlgorithm(EncryptionAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public byte[] getValue() {
        if (this.value == null) {
            return EMPTY_ARRAY;
        }
        return this.value.decodedBytes();
    }

    public KeyOperationParameters setValue(byte[] value) {
        this.value = value != null ? Base64Url.encode((byte[])value) : null;
        return this;
    }
}

