/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.AesCbc;
import com.azure.security.keyvault.keys.cryptography.ByteExtensions;
import com.azure.security.keyvault.keys.cryptography.IAuthenticatedCryptoTransform;
import com.azure.security.keyvault.keys.cryptography.ICryptoTransform;
import com.azure.security.keyvault.keys.cryptography.SymmetricEncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.Triplet;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

abstract class AesCbcHmacSha2
extends SymmetricEncryptionAlgorithm {
    private static final long BYTE_TO_BITS = 8L;
    private final ClientLogger logger = new ClientLogger(AesCbcHmacSha2.class);

    protected AesCbcHmacSha2(String name) {
        super(name);
    }

    @Override
    public ICryptoTransform createDecryptor(byte[] key, byte[] iv, byte[] authenticationData, byte[] authenticationTag) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        return this.createDecryptor(key, iv, authenticationData, authenticationTag, null);
    }

    @Override
    public ICryptoTransform createDecryptor(byte[] key, byte[] iv, byte[] authenticationData, byte[] authenticationTag, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("No key material"));
        }
        if (iv == null) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("No initialization vector"));
        }
        if (authenticationData == null) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("No authentication data"));
        }
        if (authenticationTag == null) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("No authentication tag"));
        }
        return new AesCbcHmacSha2Decryptor(this.getName(), key, iv, authenticationData, authenticationTag, provider);
    }

    @Override
    public ICryptoTransform createEncryptor(byte[] key, byte[] iv, byte[] authenticationData) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        return this.createEncryptor(key, iv, authenticationData, null);
    }

    @Override
    public ICryptoTransform createEncryptor(byte[] key, byte[] iv, byte[] authenticationData, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("No key material"));
        }
        if (iv == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("No initialization vector"));
        }
        if (authenticationData == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("No authentication data"));
        }
        return new AesCbcHmacSha2Encryptor(this.getName(), key, iv, authenticationData, provider);
    }

    static class AesCbcHmacSha2Encryptor
    extends AbstractAesCbcHmacSha2CryptoTransform {
        AesCbcHmacSha2Encryptor(String name, byte[] key, byte[] iv, byte[] authenticationData, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
            super(name, key, iv, authenticationData, (byte[] aesKey) -> new AesCbc.AesCbcEncryptor((byte[])aesKey, iv, provider));
        }

        @Override
        public byte[] doFinal(byte[] input) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException {
            byte[] output = this.inner.doFinal(input);
            this.hmac.update(output);
            byte[] hash = this.hmac.doFinal(this.aadLength);
            this.tag = new byte[this.hmacKey.length];
            System.arraycopy(hash, 0, this.tag, 0, this.tag.length);
            return output;
        }
    }

    static class AesCbcHmacSha2Decryptor
    extends AbstractAesCbcHmacSha2CryptoTransform {
        final ClientLogger logger = new ClientLogger(AesCbcHmacSha2Decryptor.class);

        AesCbcHmacSha2Decryptor(String name, byte[] key, byte[] iv, byte[] authenticationData, byte[] authenticationTag, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
            super(name, key, iv, authenticationData, aesKey -> new AesCbc.AesCbcDecryptor((byte[])aesKey, iv, provider));
            this.tag = authenticationTag;
        }

        @Override
        public byte[] doFinal(byte[] input) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException {
            this.hmac.update(input);
            byte[] hash = this.hmac.doFinal(this.aadLength);
            byte[] tag = new byte[this.hmacKey.length];
            System.arraycopy(hash, 0, tag, 0, this.hmacKey.length);
            if (!ByteExtensions.sequenceEqualConstantTime(tag, tag)) {
                throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("Data is not authentic"));
            }
            return this.inner.doFinal(input);
        }
    }

    static abstract class AbstractAesCbcHmacSha2CryptoTransform
    implements IAuthenticatedCryptoTransform {
        byte[] tag;
        final byte[] aadLength;
        final Mac hmac;
        final byte[] hmacKey;
        final ICryptoTransform inner;

        AbstractAesCbcHmacSha2CryptoTransform(String name, byte[] keyMaterial, byte[] initializationVector, byte[] authenticationData, ICryptoTransform.Factory<byte[]> factory) throws InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchPaddingException {
            Triplet<byte[], byte[], Mac> parameters = this.getAlgorithmParameters(name, keyMaterial);
            this.inner = factory.create(parameters.getLeft());
            this.hmacKey = parameters.getMiddle();
            this.hmac = parameters.getRight();
            this.aadLength = this.toBigEndian((long)authenticationData.length * 8L);
            this.hmac.update(authenticationData);
            this.hmac.update(initializationVector);
        }

        @Override
        public byte[] getTag() {
            return this.tag;
        }

        private byte[] toBigEndian(long i) {
            byte[] shortRepresentation = BigInteger.valueOf(i).toByteArray();
            byte[] longRepresentation = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            System.arraycopy(shortRepresentation, 0, longRepresentation, longRepresentation.length - shortRepresentation.length, shortRepresentation.length);
            return longRepresentation;
        }

        private Triplet<byte[], byte[], Mac> getAlgorithmParameters(String algorithm, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
            Mac hmac;
            byte[] aesKey;
            byte[] hmacKey;
            if (algorithm.equalsIgnoreCase("A128CBC-HS256")) {
                if (key.length << 3 < 256) {
                    throw new IllegalArgumentException(String.format("%s key length in bits %d < 256", algorithm, key.length << 3));
                }
                hmacKey = new byte[16];
                aesKey = new byte[16];
                System.arraycopy(key, 0, hmacKey, 0, 16);
                System.arraycopy(key, 16, aesKey, 0, 16);
                hmac = Mac.getInstance("HmacSHA256");
                hmac.init(new SecretKeySpec(hmacKey, "HmacSHA256"));
            } else if (algorithm.equalsIgnoreCase("A192CBC-HS384")) {
                if (key.length << 3 < 384) {
                    throw new IllegalArgumentException(String.format("%s key length in bits %d < 384", algorithm, key.length << 3));
                }
                hmacKey = new byte[24];
                aesKey = new byte[24];
                System.arraycopy(key, 0, hmacKey, 0, 24);
                System.arraycopy(key, 24, aesKey, 0, 24);
                hmac = Mac.getInstance("HmacSHA384");
                hmac.init(new SecretKeySpec(hmacKey, "HmacSHA384"));
            } else if (algorithm.equalsIgnoreCase("A256CBC-HS512")) {
                if (key.length << 3 < 512) {
                    throw new IllegalArgumentException(String.format("%s key length in bits %d < 512", algorithm, key.length << 3));
                }
                hmacKey = new byte[32];
                aesKey = new byte[32];
                System.arraycopy(key, 0, hmacKey, 0, 32);
                System.arraycopy(key, 32, aesKey, 0, 32);
                hmac = Mac.getInstance("HmacSHA512");
                hmac.init(new SecretKeySpec(hmacKey, "HmacSHA512"));
            } else {
                throw new IllegalArgumentException(String.format("Unsupported algorithm: %s", algorithm));
            }
            return new Triplet<byte[], byte[], Mac>(aesKey, hmacKey, hmac);
        }
    }
}

