/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.AlgorithmID;
import COSE.CoseException;
import COSE.CounterSign;
import COSE.CounterSign1;
import COSE.HeaderKeys;
import COSE.Message;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class EncryptCommon
extends Message {
    private final String AES_SPEC = "AES";
    private final String AES_CCM_SPEC = "AES/CCM/NoPadding";
    private final int AES_CCM_16_IV_LENGTH = 13;
    private final int AES_CCM_64_IV_LENGTH = 7;
    private final String AES_GCM_SPEC = "AES/GCM/NoPadding";
    private final int AES_GCM_IV_LENGTH = 96;
    protected String context;
    protected byte[] rgbEncrypt;
    SecureRandom random = new SecureRandom();

    protected byte[] decryptWithKey(byte[] rgbKey) throws CoseException {
        CBORObject algX = this.findAttribute(HeaderKeys.Algorithm);
        AlgorithmID alg = AlgorithmID.FromCBOR(algX);
        if (this.rgbEncrypt == null) {
            throw new CoseException("No Encrypted Content Specified");
        }
        switch (alg) {
            case AES_GCM_128: 
            case AES_GCM_192: 
            case AES_GCM_256: {
                this.AES_GCM_Decrypt(alg, rgbKey);
                break;
            }
            case AES_CCM_16_64_128: 
            case AES_CCM_16_64_256: 
            case AES_CCM_64_64_128: 
            case AES_CCM_64_64_256: 
            case AES_CCM_16_128_128: 
            case AES_CCM_16_128_256: 
            case AES_CCM_64_128_128: 
            case AES_CCM_64_128_256: {
                this.AES_CCM_Decrypt(alg, rgbKey);
                break;
            }
            default: {
                throw new CoseException("Unsupported Algorithm Specified");
            }
        }
        return this.rgbContent;
    }

    void encryptWithKey(byte[] rgbKey) throws CoseException, IllegalStateException {
        CBORObject algX = this.findAttribute(HeaderKeys.Algorithm);
        AlgorithmID alg = AlgorithmID.FromCBOR(algX);
        if (this.rgbContent == null) {
            throw new CoseException("No Content Specified");
        }
        switch (alg) {
            case AES_GCM_128: 
            case AES_GCM_192: 
            case AES_GCM_256: {
                this.AES_GCM_Encrypt(alg, rgbKey);
                break;
            }
            case AES_CCM_16_64_128: 
            case AES_CCM_16_64_256: 
            case AES_CCM_64_64_128: 
            case AES_CCM_64_64_256: 
            case AES_CCM_16_128_128: 
            case AES_CCM_16_128_256: 
            case AES_CCM_64_128_128: 
            case AES_CCM_64_128_256: {
                this.AES_CCM_Encrypt(alg, rgbKey);
                break;
            }
            default: {
                throw new CoseException("Unsupported Algorithm Specified");
            }
        }
        this.ProcessCounterSignatures();
    }

    private int getAES_CCM_IVSize(AlgorithmID alg) throws CoseException {
        switch (alg) {
            case AES_CCM_16_64_128: 
            case AES_CCM_16_64_256: 
            case AES_CCM_16_128_128: 
            case AES_CCM_16_128_256: {
                return 13;
            }
            case AES_CCM_64_64_128: 
            case AES_CCM_64_64_256: 
            case AES_CCM_64_128_128: 
            case AES_CCM_64_128_256: {
                return 7;
            }
        }
        throw new CoseException("Unsupported algorithm: " + (Object)((Object)alg));
    }

    private void AES_CCM_Decrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, IllegalStateException {
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key Size is incorrect");
        }
        int ivLen = this.getAES_CCM_IVSize(alg);
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        if (iv == null) {
            throw new CoseException("Missing IV during decryption");
        }
        if (iv.getType() != CBORType.ByteString) {
            throw new CoseException("IV is incorrectly formed");
        }
        if (iv.GetByteString().length != ivLen) {
            throw new CoseException("IV size is incorrect");
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/CCM/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(rgbKey, "AES"), new GCMParameterSpec(alg.getTagSize(), iv.GetByteString()));
            cipher.updateAAD(this.getAADBytes());
            this.rgbContent = new byte[cipher.getOutputSize(this.rgbEncrypt.length)];
            ByteBuffer input = ByteBuffer.wrap(this.rgbEncrypt);
            ByteBuffer output = ByteBuffer.wrap(this.rgbContent);
            cipher.doFinal(input, output);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (InvalidKeyException ex) {
            if (ex.getMessage() == "Illegal key size") {
                throw new CoseException("Unsupported key size", ex);
            }
            throw new CoseException("Decryption failure", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Decryption failure", ex);
        }
    }

    private void AES_CCM_Encrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, IllegalStateException {
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key Size is incorrect");
        }
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        int ivLen = this.getAES_CCM_IVSize(alg);
        if (iv == null) {
            byte[] tmp = new byte[ivLen];
            this.random.nextBytes(tmp);
            iv = CBORObject.FromObject((byte[])tmp);
            this.addAttribute(HeaderKeys.IV, iv, 2);
        } else {
            if (iv.getType() != CBORType.ByteString) {
                throw new CoseException("IV is incorreclty formed.");
            }
            if (iv.GetByteString().length > ivLen) {
                throw new CoseException("IV is too long.");
            }
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/CCM/NoPadding");
            cipher.init(1, (Key)new SecretKeySpec(rgbKey, "AES"), new GCMParameterSpec(alg.getTagSize(), iv.GetByteString()));
            cipher.updateAAD(this.getAADBytes());
            this.rgbEncrypt = new byte[cipher.getOutputSize(this.rgbContent.length)];
            ByteBuffer input = ByteBuffer.wrap(this.rgbContent);
            ByteBuffer output = ByteBuffer.wrap(this.rgbEncrypt);
            cipher.doFinal(input, output);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Encryption failure", ex);
        }
    }

    private void AES_GCM_Decrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException {
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key Size is incorrect");
        }
        if (iv == null) {
            throw new CoseException("Missing IV during decryption");
        }
        if (iv.getType() != CBORType.ByteString) {
            throw new CoseException("IV is incorrectly formed");
        }
        if (iv.GetByteString().length != 12) {
            throw new CoseException("IV size is incorrect");
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(rgbKey, "AES"), new GCMParameterSpec(alg.getTagSize(), iv.GetByteString()));
            cipher.updateAAD(this.getAADBytes());
            this.rgbContent = new byte[cipher.getOutputSize(this.rgbEncrypt.length)];
            ByteBuffer input = ByteBuffer.wrap(this.rgbEncrypt);
            ByteBuffer output = ByteBuffer.wrap(this.rgbContent);
            cipher.doFinal(input, output);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (InvalidKeyException ex) {
            if (ex.getMessage() == "Illegal key size") {
                throw new CoseException("Unsupported key size", ex);
            }
            throw new CoseException("Decryption failure", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Decryption failure", ex);
        }
    }

    private void AES_GCM_Encrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, IllegalStateException {
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key Size is incorrect");
        }
        CBORObject iv = this.findAttribute(HeaderKeys.IV);
        if (iv == null) {
            byte[] tmp = new byte[12];
            this.random.nextBytes(tmp);
            iv = CBORObject.FromObject((byte[])tmp);
            this.addAttribute(HeaderKeys.IV, iv, 1);
        } else {
            if (iv.getType() != CBORType.ByteString) {
                throw new CoseException("IV is incorrectly formed");
            }
            if (iv.GetByteString().length != 12) {
                throw new CoseException("IV size is incorrect");
            }
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)new SecretKeySpec(rgbKey, "AES"), new GCMParameterSpec(alg.getTagSize(), iv.GetByteString()));
            cipher.updateAAD(this.getAADBytes());
            this.rgbEncrypt = new byte[cipher.getOutputSize(this.rgbContent.length)];
            ByteBuffer input = ByteBuffer.wrap(this.rgbContent);
            ByteBuffer output = ByteBuffer.wrap(this.rgbEncrypt);
            cipher.doFinal(input, output);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Encryption failure", ex);
        }
    }

    private byte[] getAADBytes() {
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)this.context);
        this.rgbProtected = this.objProtected.size() == 0 ? new byte[0] : this.objProtected.EncodeToBytes();
        obj.Add((Object)this.rgbProtected);
        obj.Add(CBORObject.FromObject((byte[])this.externalData));
        return obj.EncodeToBytes();
    }

    public byte[] getEncryptedContent() throws CoseException {
        if (this.rgbEncrypt == null) {
            throw new CoseException("No Encrypted Content Specified");
        }
        return this.rgbEncrypt;
    }

    public void setEncryptedContent(byte[] rgb) {
        this.rgbEncrypt = rgb;
    }

    @Override
    protected void ProcessCounterSignatures() throws CoseException {
        if (!this.counterSignList.isEmpty()) {
            if (this.counterSignList.size() == 1) {
                ((CounterSign)this.counterSignList.get(0)).sign(this.rgbProtected, this.rgbEncrypt);
                this.addAttribute(HeaderKeys.CounterSignature, ((CounterSign)this.counterSignList.get(0)).EncodeToCBORObject(), 2);
            } else {
                CBORObject list = CBORObject.NewArray();
                for (CounterSign sig : this.counterSignList) {
                    sig.sign(this.rgbProtected, this.rgbEncrypt);
                    list.Add(sig.EncodeToCBORObject());
                }
                this.addAttribute(HeaderKeys.CounterSignature, list, 2);
            }
        }
        if (this.counterSign1 != null) {
            this.counterSign1.sign(this.rgbProtected, this.rgbEncrypt);
            this.addAttribute(HeaderKeys.CounterSignature0, this.counterSign1.EncodeToCBORObject(), 2);
        }
    }

    @Override
    public boolean validate(CounterSign1 countersignature) throws CoseException {
        return countersignature.validate(this.rgbProtected, this.rgbEncrypt);
    }

    @Override
    public boolean validate(CounterSign countersignature) throws CoseException {
        return countersignature.validate(this.rgbProtected, this.rgbEncrypt);
    }
}

