/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.client.api.entity;

import com.atlassian.stash.rest.client.api.entity.Project;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import javax.annotation.Nullable;

public class Repository {
    private final String slug;
    private final long id;
    private final String name;
    private final boolean isPublic;
    private final String sshCloneUrl;
    private final String httpCloneUrl;
    private final String selfUrl;
    private final Project project;
    private final Repository origin;

    public Repository(String slug, long id, String name, boolean isPublic, String sshCloneUrl, String httpCloneUrl, String selfUrl, Project project, Repository origin) {
        this.slug = slug;
        this.id = id;
        this.name = name;
        this.isPublic = isPublic;
        this.sshCloneUrl = sshCloneUrl;
        this.httpCloneUrl = httpCloneUrl;
        this.selfUrl = selfUrl;
        this.project = project;
        this.origin = origin;
    }

    public String getSlug() {
        return this.slug;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean hasCloneUrl() {
        return !Strings.isNullOrEmpty((String)this.getHttpCloneUrl()) || !Strings.isNullOrEmpty((String)this.getSshCloneUrl());
    }

    public String getSshCloneUrl() {
        return this.sshCloneUrl;
    }

    public String getHttpCloneUrl() {
        return this.httpCloneUrl;
    }

    public String getSelfUrl() {
        return this.selfUrl;
    }

    public Project getProject() {
        return this.project;
    }

    @Nullable
    public Repository getOrigin() {
        return this.origin;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("slug", (Object)this.slug).add("id", (Object)this.id).add("name", (Object)this.name).add("public", (Object)this.isPublic).add("sshCloneUrl", (Object)this.sshCloneUrl).add("httpCloneUrl", (Object)this.httpCloneUrl).add("selfUrl", (Object)this.selfUrl).add("project", (Object)this.project).add("origin", (Object)this.origin).toString();
    }
}

