/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.client.api.entity;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Page<T> {
    private final int size;
    private final int limit;
    private final boolean lastPage;
    private final int start;
    @Nullable
    private final Integer nextPageStart;
    @Nonnull
    private final List<T> values;

    public Page(int size, int limit, boolean lastPage, int start, @Nullable Integer nextPageStart, @Nonnull Iterable<T> values) {
        this.size = size;
        this.limit = limit;
        this.lastPage = lastPage;
        this.values = ImmutableList.copyOf(values);
        this.start = start;
        this.nextPageStart = nextPageStart;
    }

    public int getSize() {
        return this.size;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isLastPage() {
        return this.lastPage;
    }

    @Nonnull
    public List<T> getValues() {
        return this.values;
    }

    public int getStart() {
        return this.start;
    }

    @Nullable
    public Integer getNextPageStart() {
        return this.nextPageStart;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("size", (Object)this.size).add("limit", (Object)this.limit).add("lastPage", (Object)this.lastPage).add("start", (Object)this.start).add("nextPageStart", (Object)this.nextPageStart).toString();
    }
}

