/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.client.api;

import com.atlassian.stash.rest.client.api.StashError;
import java.util.Collections;
import java.util.List;

public class StashException
extends RuntimeException {
    private List<StashError> errors;

    public StashException(String message) {
        super(message);
        this.errors = StashException.toErrors(this.getMessage(), this);
    }

    public StashException(String message, Throwable cause) {
        super(message, cause);
        this.errors = StashException.toErrors(this.getMessage(), cause);
    }

    public StashException(Throwable cause) {
        super(cause);
        this.errors = StashException.toErrors(this.getMessage(), cause);
    }

    public StashException(List<StashError> errors) {
        super(errors.isEmpty() ? null : errors.get(0).getMessage());
        this.errors = errors;
    }

    public List<StashError> getErrors() {
        return this.errors;
    }

    public static List<StashError> toErrors(String message) {
        return StashException.toErrors(message, null);
    }

    public static List<StashError> toErrors(String message, Throwable e) {
        return Collections.singletonList(new StashError(message, null, e != null ? e.getClass().getSimpleName() : null));
    }
}

