/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.spring.quartz1;

import com.atlassian.spring.quartz1.AdaptableJobFactory;
import com.atlassian.spring.quartz1.QuartzJobBean;
import com.atlassian.spring.quartz1.SchedulerContextAware;
import java.lang.reflect.Method;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.SchedulerContext;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValues;
import org.springframework.util.ReflectionUtils;

public class SpringBeanJobFactory
extends AdaptableJobFactory
implements SchedulerContextAware {
    private String[] ignoredUnknownProperties;
    private SchedulerContext schedulerContext;

    public void setIgnoredUnknownProperties(String ... ignoredUnknownProperties) {
        this.ignoredUnknownProperties = ignoredUnknownProperties;
    }

    @Override
    public void setSchedulerContext(SchedulerContext schedulerContext) {
        this.schedulerContext = schedulerContext;
    }

    @Override
    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        Object job = super.createJobInstance(bundle);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)job);
        if (this.isEligibleForPropertyPopulation(bw.getWrappedInstance())) {
            MutablePropertyValues pvs = new MutablePropertyValues();
            if (this.schedulerContext != null) {
                pvs.addPropertyValues((Map)this.schedulerContext);
            }
            pvs.addPropertyValues((Map)this.getJobDetailDataMap(bundle));
            pvs.addPropertyValues((Map)this.getTriggerDataMap(bundle));
            if (this.ignoredUnknownProperties != null) {
                for (String propName : this.ignoredUnknownProperties) {
                    if (!pvs.contains(propName) || bw.isWritableProperty(propName)) continue;
                    pvs.removePropertyValue(propName);
                }
                bw.setPropertyValues((PropertyValues)pvs);
            } else {
                bw.setPropertyValues((PropertyValues)pvs, true);
            }
        }
        return job;
    }

    protected boolean isEligibleForPropertyPopulation(Object jobObject) {
        return !(jobObject instanceof QuartzJobBean);
    }

    private JobDataMap getJobDetailDataMap(TriggerFiredBundle bundle) throws Exception {
        Method getJobDetail = bundle.getClass().getMethod("getJobDetail", new Class[0]);
        Object jobDetail = ReflectionUtils.invokeMethod((Method)getJobDetail, (Object)bundle);
        Method getJobDataMap = jobDetail.getClass().getMethod("getJobDataMap", new Class[0]);
        return (JobDataMap)ReflectionUtils.invokeMethod((Method)getJobDataMap, (Object)jobDetail);
    }

    private JobDataMap getTriggerDataMap(TriggerFiredBundle bundle) throws Exception {
        Method getTrigger = bundle.getClass().getMethod("getTrigger", new Class[0]);
        Object trigger = ReflectionUtils.invokeMethod((Method)getTrigger, (Object)bundle);
        Method getJobDataMap = trigger.getClass().getMethod("getJobDataMap", new Class[0]);
        return (JobDataMap)ReflectionUtils.invokeMethod((Method)getJobDataMap, (Object)trigger);
    }
}

