/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.spring.quartz1;

import com.atlassian.spring.quartz1.DelegatingJob;
import java.lang.reflect.Method;
import org.quartz.Job;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.util.ReflectionUtils;

public class AdaptableJobFactory
implements JobFactory {
    public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        return this.newJob(bundle);
    }

    public Job newJob(TriggerFiredBundle bundle) throws SchedulerException {
        try {
            Object jobObject = this.createJobInstance(bundle);
            return this.adaptJob(jobObject);
        }
        catch (Exception ex) {
            throw new SchedulerException("Job instantiation failed", (Throwable)ex);
        }
    }

    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        Method getJobDetail = bundle.getClass().getMethod("getJobDetail", new Class[0]);
        Object jobDetail = ReflectionUtils.invokeMethod((Method)getJobDetail, (Object)bundle);
        Method getJobClass = jobDetail.getClass().getMethod("getJobClass", new Class[0]);
        Class jobClass = (Class)ReflectionUtils.invokeMethod((Method)getJobClass, (Object)jobDetail);
        return jobClass.newInstance();
    }

    protected Job adaptJob(Object jobObject) throws Exception {
        if (jobObject instanceof Job) {
            return (Job)jobObject;
        }
        if (jobObject instanceof Runnable) {
            return new DelegatingJob((Runnable)jobObject);
        }
        throw new IllegalArgumentException("Unable to execute job class [" + jobObject.getClass().getName() + "]: only [org.quartz.Job] and [java.lang.Runnable] supported.");
    }
}

