/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.store.algorithm.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Set;

public class SafeObjectInputStream
extends ObjectInputStream {
    private final Set<String> allowList;

    public SafeObjectInputStream(InputStream inputStream, Set<String> allowList) throws IOException {
        super(inputStream);
        this.allowList = allowList;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass cls) throws IOException, ClassNotFoundException {
        if (!this.allowList.contains(cls.getName())) {
            throw new InvalidClassException("Unsupported class => " + cls.getName());
        }
        return super.resolveClass(cls);
    }
}

