package com.atlassian.sal.api.usersettings;

import com.atlassian.fugue.Option;

import java.util.Set;

/**
 * An immutable container of user-specific settings.
 *
 * Key is global - two values of different types can _not_ be stored against a common key.
 */
public interface UserSettings
{
    /**
     * @param key the setting key being queried
     * @return a {@link Option.Some Some} containing the String stored against key if one exists (and is a String),
     * a {@link Option.None} otherwise.
     */
    Option<String> getString(String key);

    /**
     * @param key the setting key being queried
     * @return a {@link Option.Some Some} containing the Boolean stored against key if one exists (and is a Boolean),
     * a {@link Option.None} otherwise.
     */
    Option<Boolean> getBoolean(String key);

    /**
     * @param key the setting key being queried
     * @return a {@link Option.Some Some} containing the Long stored against key if one exists (and is a Long),
     * a {@link Option.None} otherwise.
     */
    Option<Long> getLong(String key);

    /**
     * @return the set of keys known to this UserSettings
     */
    Set<String> getKeys();
}
