package com.atlassian.plugin.event.events;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Event thrown when the container a plugin is installed into either rejects the plugin or fails altogether.
 *
 * @since 2.2.0
 * @see com.atlassian.plugin.event.events
 */
public class PluginContainerFailedEvent
{
    private final Object container;
    private final String key;
    private final Throwable cause;

    public PluginContainerFailedEvent(final Object container, final String key, final Throwable cause)
    {
        this.key = checkNotNull(key, "The bundle symbolic name must be available");
        this.container = container;
        this.cause = cause;
    }

    public Object getContainer()
    {
        return container;
    }

    public String getPluginKey()
    {
        return key;
    }

    public Throwable getCause()
    {
        return cause;
    }
}
