/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.spring.web.servlet.support;

import com.atlassian.johnson.context.JohnsonContextListener;
import com.atlassian.johnson.spring.web.context.JohnsonContextLoaderListener;
import com.atlassian.johnson.spring.web.servlet.JohnsonDispatcherServlet;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.support.AbstractDispatcherServletInitializer;

public abstract class AbstractJohnsonDispatcherServletInitializer
extends AbstractDispatcherServletInitializer {
    protected ContextLoaderListener createContextLoaderListener(WebApplicationContext context) {
        return new JohnsonContextLoaderListener(context);
    }

    protected DispatcherServlet createDispatcherServlet(WebApplicationContext context) {
        return new JohnsonDispatcherServlet(context);
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        this.registerJohnsonContextListener(servletContext);
        super.onStartup(servletContext);
    }

    protected void registerContextLoaderListener(ServletContext servletContext) {
        WebApplicationContext context = this.createRootApplicationContext();
        if (context == null) {
            this.logger.debug((Object)"No ContextLoaderListener registered, as createRootApplicationContext() did not return an application context");
        } else {
            servletContext.addListener((EventListener)this.createContextLoaderListener(context));
        }
    }

    protected void registerDispatcherServlet(ServletContext servletContext) {
        String servletName = this.getServletName();
        Assert.hasLength((String)servletName, (String)"getServletName() may not return empty or null");
        WebApplicationContext servletAppContext = this.createServletApplicationContext();
        Assert.notNull((Object)servletAppContext, (String)("createServletApplicationContext() did not return an application context for servlet [" + servletName + "]"));
        ServletRegistration.Dynamic registration = servletContext.addServlet(servletName, (Servlet)this.createDispatcherServlet(servletAppContext));
        Assert.notNull((Object)registration, (String)("Failed to register servlet with name '" + servletName + "'. Check if there is another servlet registered under the same name."));
        registration.setAsyncSupported(this.isAsyncSupported());
        registration.setLoadOnStartup(1);
        registration.addMapping(this.getServletMappings());
        Object[] filters = this.getServletFilters();
        if (!ObjectUtils.isEmpty((Object[])filters)) {
            for (Object filter : filters) {
                this.registerServletFilter(servletContext, (Filter)filter);
            }
        }
        this.customizeRegistration(registration);
    }

    protected void registerJohnsonContextListener(ServletContext servletContext) {
        JohnsonContextListener.register((ServletContext)servletContext);
    }
}

