package com.atlassian.healthcheck.checks.plugin;

import static com.atlassian.healthcheck.checks.plugin.PluginHealthCheckMode.DEFAULT_NO_FAIL;
import static com.atlassian.healthcheck.checks.plugin.PluginHealthCheckMode.DISABLED;
import static com.atlassian.healthcheck.checks.plugin.PluginHealthCheckMode.FORCE_NO_FAIL;
import static com.atlassian.healthcheck.checks.plugin.PluginHealthCheckMode.HARD_FAIL;

/**
 * Constants for {@code com.atlassian.healthcheck.checks.plugin.AbstractPluginHealthCheck}s
 * from atlassian-healthcheck plugin, considered part of the API
 * because they are depended on by in-product tests.
 */
public final class PluginHealthCheckConstants {
    private PluginHealthCheckConstants() {}

    /**
     * See {@code com.atlassian.healthcheck.checks.plugin.AbstractPluginHealthCheck} subclasses in atlassian-healthcheck plugin
     */
    public static final String DISABLED_PLUGINS_HEALTHCHECK = "Disabled Plugins";
    public static final String DISABLED_PLUGIN_MODULES_HEALTHCHECK = "Disabled Plugin Modules";
    public static final String DISABLED_BY_DEFAULT_PLUGINS_HEALTHCHECK = "Disabled By Default Plugins";
    public static final String DISABLED_BY_DEFAULT_PLUGIN_MODULES_HEALTHCHECK = "Disabled By Default Plugin Modules";

    /**
     * See {@code com.atlassian.healthcheck.checks.plugin.AbstractPluginHealthCheck} in atlassian-healthcheck plugin
     */
    public static final String MODE_PREFIX = "mode=";
    public static final String DISABLED_MODE = "(" + MODE_PREFIX + DISABLED.name() + ")";
    public static final String HARD_FAIL_MODE = "(" + MODE_PREFIX + HARD_FAIL.name() + ")";
    public static final String DEFAULT_NO_FAIL_MODE = "(" + MODE_PREFIX + DEFAULT_NO_FAIL.name() + ")";
    public static final String FORCE_NO_FAIL_MODE = "(" + MODE_PREFIX + FORCE_NO_FAIL.name() + ")";
    public static final String PASS = "PASS";
    public static final String FAILED = "FAILED";
    public static final String WHITELISTED = "WHITELISTED";
}
