package com.atlassian.healthcheck.checks;

/**
 * Constants for atlassian-healthcheck plugin, considered part of the API
 * because they are depended on by in-product tests.
 */
public final class HealthCheckConstants {
    private HealthCheckConstants() {}

    /**
     * See {@code com.atlassian.healthcheck.core.rest.HealthCheckResource} in atlassian-healthcheck plugin
     */
    public static final String HEALTH_CHECK_BASE_PATH = "rest/healthCheck/1.0";

    /**
     * See {@code com.atlassian.healthcheck.core.rest.HealthCheckResource#checkDetails}
     */
    public static final String CHECK_DETAILS = "/checkDetails";
    public static final String HEALTH_CHECK_DETAILS_JSON = HEALTH_CHECK_BASE_PATH + HealthCheckConstants.CHECK_DETAILS + ".json";

    public static final String HEALTH_CHECK_STATUS_FIELD = "status";
    public static final String HEALTH_CHECK_NAME_FIELD = "name";
    public static final String HEALTH_CHECK_IS_HEALTHY_FIELD = "isHealthy";
    public static final String HEALTH_CHECK_FAILURE_REASON_FIELD = "failureReason";

    public static final String HOST_APPLICATION_STATUS_HEALTH_CHECK = "Host Application Status Check";
}
