package com.atlassian.crowd.model.rememberme;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.time.LocalDateTime;

public interface CrowdRememberMeToken {
    /**
     * @return the id of this auth token.
     */
    Long getId();

    /**
     * @return a base64 encoded random string.
     */
    @Nonnull
    String getToken();

    /**
     * @return a random string denoting the series of tokens for a user
     */
    @Nonnull
    String getSeries();

    /**
     * @return The user name associated with this token
     */
    @Nonnull
    String getUsername();

    /**
     * @return the time at which this token will expire
     */
    @Nonnull
    LocalDateTime getCreatedTime();

    /**
     * @return the time at which this token will expire
     */
    LocalDateTime getUsedTime();

    /**
     * @return directory id associated with the token
     */
    @Nonnull
    Long getDirectoryId();

    /**
     * @return remote address if available
     */
    @Nullable
    String getRemoteAddress();
}
