package com.atlassian.crowd.model.event;

import java.util.Map;
import java.util.Set;

import com.atlassian.crowd.model.user.User;

public class UserEvent extends AbstractAttributeEvent {
    private final User user;

    public UserEvent(Operation operation, Long directoryId, User user, Map<String, Set<String>> storedAttributes, Set<String> deletedAttributes) {
        super(operation, directoryId, storedAttributes, deletedAttributes);
        this.user = user;
    }

    public User getUser() {
        return user;
    }

    @Override
    public String toString() {
        return "UserEvent{" +
                "operation=" + getOperation() +
                ",directory=" + getDirectoryId() +
                ",storedAttributes=" + getStoredAttributes() +
                ",deletedAttributes=" + getDeletedAttributes() +
                ",user=" + user +
                '}';
    }
}
