package com.atlassian.crowd.model.application;

import java.util.Set;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;

/**
 * Represents a mapping of an application to a directory. Only directories with a mapping to an application are
 * visible to the application.
 *
 * @since 2.12
 */
public interface ApplicationDirectoryMapping {

    /**
     * @return the directory mapped to the application
     */
    Directory getDirectory();

    /**
     * Returns <tt>true</tt> if all the users in the directory are allowed to authenticate with the application. If the
     * value is false, then the user is required to be in an authorised group.
     *
     * @return <tt>true</tt> if all the users in the directory are allowed to authenticate with the application
     * @see #getAuthorisedGroupNames()
     */
    boolean isAllowAllToAuthenticate();

    /**
     * Returns a set of mappings to groups that are authorised to authenticate with the application. This set is not
     * used if {@link #isAllowAllToAuthenticate()} returns <tt>true</tt>.
     *
     * @return set of mappings to groups that are authorised to authenticate with the application
     */
    Set<String> getAuthorisedGroupNames();

    /**
     * Returns a set of operations that the application is allowed to perform on the directory.
     *
     * @return set of operations that the application is allowed to perform on the directory
     */
    Set<OperationType> getAllowedOperations();
}