/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.recovery;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.crowd.core.event.MultiEventPublisher;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.BeforeGroupRemoval;
import com.atlassian.crowd.manager.directory.DirectoryManagerGeneric;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.manager.recovery.RecoveryModeService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class RecoveryModeAwareDirectoryManager
extends DirectoryManagerGeneric {
    private final RecoveryModeService recoveryModeService;

    public RecoveryModeAwareDirectoryManager(DirectoryDao directoryDao, ApplicationDAO applicationDAO, MultiEventPublisher eventPublisher, PermissionManager permissionManager, DirectoryInstanceLoader directoryInstanceLoader, DirectorySynchroniser directorySynchroniser, DirectoryPollerManager directoryPollerManager, ClusterLockService clusterLockService, SynchronisationStatusManager synchronisationStatusManager, BeforeGroupRemoval beforeGroupRemoval, RecoveryModeService recoveryModeService) {
        super(directoryDao, applicationDAO, eventPublisher, permissionManager, directoryInstanceLoader, directorySynchroniser, directoryPollerManager, clusterLockService, synchronisationStatusManager, beforeGroupRemoval);
        this.recoveryModeService = (RecoveryModeService)Preconditions.checkNotNull((Object)recoveryModeService, (Object)"recoveryModeService");
    }

    @Override
    public Directory findDirectoryById(long directoryId) throws DirectoryNotFoundException {
        if (this.recoveryModeService.isRecoveryModeOn() && this.recoveryModeService.getRecoveryDirectory().getId().equals(directoryId)) {
            return this.recoveryModeService.getRecoveryDirectory();
        }
        return super.findDirectoryById(directoryId);
    }

    @Override
    public List<Directory> findAllDirectories() {
        List<Directory> directories = super.findAllDirectories();
        if (this.recoveryModeService.isRecoveryModeOn()) {
            return ImmutableList.builder().add((Object)this.recoveryModeService.getRecoveryDirectory()).addAll(directories).build();
        }
        return directories;
    }

    @Override
    public Directory findDirectoryByName(String name) throws DirectoryNotFoundException {
        if (this.recoveryModeService.isRecoveryModeOn() && this.recoveryModeService.getRecoveryDirectory().getName().equalsIgnoreCase(name)) {
            return this.recoveryModeService.getRecoveryDirectory();
        }
        return super.findDirectoryByName(name);
    }
}

