/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.recovery;

import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.event.EventStore;
import com.atlassian.crowd.manager.application.ApplicationServiceGeneric;
import com.atlassian.crowd.manager.application.SearchStrategyFactory;
import com.atlassian.crowd.manager.avatar.AvatarProvider;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.manager.recovery.RecoveryModeService;
import com.atlassian.crowd.manager.webhook.WebhookRegistry;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class RecoveryModeAwareApplicationService
extends ApplicationServiceGeneric {
    private final RecoveryModeService recoveryModeService;
    private final ApplicationFactory applicationFactory;

    public RecoveryModeAwareApplicationService(DirectoryManager directoryManager, SearchStrategyFactory searchStrategyFactory, PermissionManager permissionManager, EventPublisher eventPublisher, EventStore eventStore, WebhookRegistry webhookRegistry, AvatarProvider avatarProvider, ApplicationFactory applicationFactory, RecoveryModeService recoveryModeService) {
        super(directoryManager, searchStrategyFactory, permissionManager, eventPublisher, eventStore, webhookRegistry, avatarProvider);
        this.applicationFactory = (ApplicationFactory)Preconditions.checkNotNull((Object)applicationFactory);
        this.recoveryModeService = (RecoveryModeService)Preconditions.checkNotNull((Object)recoveryModeService, (Object)"recoveryModeService");
    }

    @Override
    protected List<Directory> getActiveDirectories(Application application) {
        List<Directory> directories = super.getActiveDirectories(application);
        if (this.recoveryModeService.isRecoveryModeOn() && application.equals(this.applicationFactory.getApplication())) {
            return ImmutableList.builder().add((Object)this.recoveryModeService.getRecoveryDirectory()).addAll(directories).build();
        }
        return directories;
    }

    @Override
    public boolean isUserAuthorised(Application application, String username) {
        if (this.recoveryModeService.isRecoveryModeOn() && IdentifierUtils.equalsInLowerCase((String)username, (String)this.recoveryModeService.getRecoveryUsername()) && application.equals(this.applicationFactory.getApplication())) {
            return true;
        }
        return super.isUserAuthorised(application, username);
    }
}

