/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.property;

import com.atlassian.crowd.dao.property.PropertyDAO;
import com.atlassian.crowd.event.configuration.AuditLogConfigurationUpdatedEvent;
import com.atlassian.crowd.event.configuration.ConfigurationPropertyUpdatedEvent;
import com.atlassian.crowd.event.configuration.SmtpServerUpdatedEvent;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.audit.AuditLogConfiguration;
import com.atlassian.crowd.manager.audit.RetentionPeriod;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.util.mail.SMTPServer;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.mail.internet.InternetAddress;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PropertyManagerGeneric
implements PropertyManager {
    private static final Logger logger = LoggerFactory.getLogger(PropertyManagerGeneric.class);
    private static final int DEFAULT_SESSION_TIME_IN_MINUTES = 5;
    private final PropertyDAO propertyDAO;
    private final EventPublisher eventPublisher;

    public PropertyManagerGeneric(PropertyDAO propertyDAO, EventPublisher eventPublisher) {
        this.propertyDAO = propertyDAO;
        this.eventPublisher = eventPublisher;
    }

    public String getDeploymentTitle() throws PropertyManagerException {
        try {
            Property property = this.getPropertyObject("deployment.title");
            return property.getValue();
        }
        catch (Exception e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public void setDeploymentTitle(String title) {
        this.setProperty("deployment.title", title);
    }

    public String getDomain() {
        String domain;
        block2: {
            domain = null;
            try {
                Property property = this.getPropertyObject("domain");
                domain = property.getValue();
            }
            catch (ObjectNotFoundException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Failed to find a domain property.");
            }
        }
        return domain;
    }

    public void setDomain(String domain) {
        this.setProperty("domain", domain);
    }

    public boolean isSecureCookie() {
        try {
            Property property = this.getPropertyObject("secure.cookie");
            return Boolean.parseBoolean(property.getValue());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setSecureCookie(boolean secure) {
        String oldValue = Boolean.toString(this.isSecureCookie());
        String newValue = Boolean.toString(secure);
        this.setProperty("secure.cookie", newValue, false);
        if (!Objects.equals(oldValue, newValue)) {
            this.eventPublisher.publish((Object)new ConfigurationPropertyUpdatedEvent("secure.cookie", oldValue, newValue));
        }
    }

    public void setCacheEnabled(boolean enabled) {
        String oldValue = Boolean.toString(this.isCacheEnabled());
        String newValue = Boolean.toString(enabled);
        this.setProperty("cache.enabled", newValue, false);
        if (!Objects.equals(oldValue, newValue)) {
            this.eventPublisher.publish((Object)new ConfigurationPropertyUpdatedEvent("cache.enabled", oldValue, newValue));
        }
    }

    public boolean isCacheEnabled() {
        try {
            Property property = this.getPropertyObject("cache.enabled");
            return Boolean.parseBoolean(property.getValue());
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getSessionTime() {
        try {
            Property property = this.getPropertyObject("session.time");
            long b = Long.parseLong(property.getValue());
            return TimeUnit.MILLISECONDS.toMinutes(b);
        }
        catch (Exception e) {
            return 5L;
        }
    }

    public void setSessionTime(long time) {
        this.setProperty("session.time", Long.toString(TimeUnit.MINUTES.toMillis(time)));
    }

    public SMTPServer getSMTPServer() throws PropertyManagerException {
        SMTPServer server;
        InternetAddress fromAddress;
        try {
            fromAddress = new InternetAddress(this.getPropertyObject("mailserver.sender").getValue());
        }
        catch (Exception e) {
            throw new PropertyManagerException((Throwable)e);
        }
        String prefix = null;
        try {
            prefix = this.getPropertyObject("mailserver.prefix").getValue();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            server = this.buildJNDIServer(fromAddress, prefix);
        }
        catch (ObjectNotFoundException ignored) {
            server = this.buildSMTPServer(fromAddress, prefix);
        }
        return server;
    }

    private SMTPServer buildJNDIServer(InternetAddress fromAddress, String prefix) throws ObjectNotFoundException {
        String jndiLocation = this.getPropertyObject("mailserver.jndi").getValue();
        if (StringUtils.isNotBlank((CharSequence)jndiLocation)) {
            return new SMTPServer(jndiLocation, fromAddress, prefix);
        }
        throw new ObjectNotFoundException(Property.class, (Object)"JNDI location");
    }

    private SMTPServer buildSMTPServer(InternetAddress fromAddress, String prefix) throws PropertyManagerException {
        String host;
        try {
            host = this.getPropertyObject("mailserver.host").getValue();
        }
        catch (ObjectNotFoundException e) {
            throw new PropertyManagerException((Throwable)e);
        }
        String password = null;
        try {
            password = this.getPropertyObject("mailserver.password").getValue();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        String username = null;
        try {
            username = this.getPropertyObject("mailserver.username").getValue();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        int port = 25;
        try {
            String value = this.getPropertyObject("mailserver.port").getValue();
            if (StringUtils.isNotBlank((CharSequence)value)) {
                port = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("SMTP port number was not a valid number", e);
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        boolean useSSL = false;
        try {
            useSSL = Boolean.valueOf(this.getPropertyObject("mailserver.usessl").getValue());
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return new SMTPServer(port, prefix, fromAddress, password, username, host, useSSL);
    }

    public void setSMTPServer(SMTPServer server) {
        SMTPServer oldValue = this.safeGetSMTPServer();
        this.setProperty("mailserver.prefix", server.getPrefix(), false);
        this.setProperty("mailserver.sender", server.getFrom().toString(), false);
        if (StringUtils.isNotBlank((CharSequence)server.getJndiLocation())) {
            this.setProperty("mailserver.jndi", server.getJndiLocation(), false);
            this.setProperty("mailserver.host", "", false);
            this.setProperty("mailserver.password", "", false);
            this.setProperty("mailserver.username", "", false);
            this.setProperty("mailserver.port", "", false);
            this.setProperty("mailserver.usessl", "", false);
        } else {
            this.setProperty("mailserver.host", server.getHost(), false);
            this.setProperty("mailserver.password", server.getPassword(), false);
            this.setProperty("mailserver.username", server.getUsername(), false);
            this.setProperty("mailserver.port", String.valueOf(server.getPort()), false);
            this.setProperty("mailserver.usessl", String.valueOf(server.getUseSSL()), false);
            this.setProperty("mailserver.jndi", "", false);
        }
        SMTPServer newValue = this.safeGetSMTPServer();
        if (!Objects.equals(oldValue, newValue)) {
            this.eventPublisher.publish((Object)new SmtpServerUpdatedEvent(oldValue, newValue));
        }
    }

    private SMTPServer safeGetSMTPServer() {
        try {
            return this.getSMTPServer();
        }
        catch (PropertyManagerException e) {
            return null;
        }
    }

    public Key getDesEncryptionKey() throws PropertyManagerException {
        try {
            String keyStr = this.getPropertyObject("des.encryption.key").getValue();
            DESKeySpec ks = new DESKeySpec(Base64.decodeBase64((String)keyStr));
            return SecretKeyFactory.getInstance("DES").generateSecret(ks);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
        catch (ObjectNotFoundException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"DES_USAGE"}, justification="Only used for DESPasswordEncoder, which is not used by default")
    public void generateDesEncryptionKey() throws PropertyManagerException {
        try {
            try {
                this.getPropertyObject("des.encryption.key");
                return;
            }
            catch (Exception exception) {
                SecretKey key = KeyGenerator.getInstance("DES").generateKey();
                this.setProperty("des.encryption.key", Base64.encodeBase64String((byte[])key.getEncoded()));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public void setSMTPTemplate(String template) {
        this.setProperty("mailserver.message.template", template);
    }

    @Deprecated
    public String getSMTPTemplate() throws PropertyManagerException {
        try {
            Property property = this.getPropertyObject("mailserver.message.template");
            return property.getValue();
        }
        catch (Exception e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public void setCurrentLicenseResourceTotal(int total) {
        this.setProperty("current.license.resource.total", Integer.toString(total), false);
    }

    public int getCurrentLicenseResourceTotal() {
        int total = 0;
        try {
            total = Integer.parseInt(this.getPropertyObject("current.license.resource.total").getValue());
        }
        catch (Exception e) {
            logger.debug("Failed to find current resource total.", (Throwable)e);
        }
        return total;
    }

    public void setNotificationEmail(String notificationEmail) {
        this.setProperty("notification.email", notificationEmail);
    }

    public String getNotificationEmail() throws PropertyManagerException {
        try {
            return this.getPropertyObject("notification.email").getValue();
        }
        catch (ObjectNotFoundException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isGzipEnabled() throws PropertyManagerException {
        return true;
    }

    public void setGzipEnabled(boolean gzip) {
    }

    public Integer getBuildNumber() throws PropertyManagerException {
        try {
            return Integer.valueOf(this.getPropertyObject("build.number").getValue());
        }
        catch (ObjectNotFoundException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public void setBuildNumber(Integer buildNumber) {
        this.setProperty("build.number", buildNumber.toString());
    }

    public String getTrustedProxyServers() throws PropertyManagerException {
        try {
            return this.getPropertyObject("trusted.proxy.servers").getValue();
        }
        catch (ObjectNotFoundException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public void setTrustedProxyServers(String proxyServers) {
        this.setProperty("trusted.proxy.servers", proxyServers);
    }

    public void setAuditLogConfiguration(AuditLogConfiguration newConfiguration) {
        AuditLogConfiguration oldConfiguration = this.getAuditLogConfiguration();
        if (!Objects.equals(oldConfiguration, newConfiguration)) {
            this.setProperty("audit.log.retention.period", newConfiguration.getRetentionPeriod().name(), false);
            this.eventPublisher.publish((Object)new AuditLogConfigurationUpdatedEvent(oldConfiguration, newConfiguration));
        }
    }

    public AuditLogConfiguration getAuditLogConfiguration() {
        try {
            return new AuditLogConfiguration(RetentionPeriod.valueOf((String)this.getProperty("audit.log.retention.period")));
        }
        catch (ObjectNotFoundException | IllegalArgumentException e) {
            if (e instanceof IllegalArgumentException) {
                logger.warn("Found invalid audit log retention period persisted in database, using the default instead", e);
            }
            return AuditLogConfiguration.defaultConfiguration();
        }
    }

    public boolean isUsingDatabaseTokenStorage() {
        return this.getBoolean("database.token.storage.enabled", true);
    }

    public void setUsingDatabaseTokenStorage(boolean usingMemoryTokenStorage) {
        String oldValue = Boolean.toString(this.isUsingDatabaseTokenStorage());
        String newValue = Boolean.toString(usingMemoryTokenStorage);
        this.setProperty("database.token.storage.enabled", newValue, false);
        if (!Objects.equals(oldValue, newValue)) {
            this.eventPublisher.publish((Object)new ConfigurationPropertyUpdatedEvent("database.token.storage.enabled", oldValue, newValue));
        }
    }

    public boolean isIncludeIpAddressInValidationFactors() {
        return this.getBoolean("validation.factors.include_ip_address", true);
    }

    public boolean isUseWebAvatars() {
        return this.getBoolean("webavatars.enabled", false);
    }

    public void setUseWebAvatars(boolean useWebAvatars) {
        String oldValue = Boolean.toString(this.isUseWebAvatars());
        String newValue = Boolean.toString(useWebAvatars);
        this.setProperty("webavatars.enabled", newValue, false);
        if (!Objects.equals(oldValue, newValue)) {
            this.eventPublisher.publish((Object)new ConfigurationPropertyUpdatedEvent("webavatars.enabled", oldValue, newValue));
        }
    }

    public CookieConfiguration getCookieConfiguration() {
        String cookieName = this.getString("cookie.tokenkey", "crowd.token_key");
        return new CookieConfiguration(this.getDomain(), this.isSecureCookie(), cookieName);
    }

    public void setCookieConfiguration(CookieConfiguration cookieConfiguration) {
        this.setDomain(cookieConfiguration.getDomain());
        this.setSecureCookie(cookieConfiguration.isSecure());
        this.setProperty("cookie.tokenkey", cookieConfiguration.getName());
    }

    public void setIncludeIpAddressInValidationFactors(boolean includeIpAddressInValidationFactors) {
        String oldValue = Boolean.toString(this.isIncludeIpAddressInValidationFactors());
        String newValue = Boolean.toString(includeIpAddressInValidationFactors);
        this.setProperty("validation.factors.include_ip_address", newValue, false);
        if (!Objects.equals(oldValue, newValue)) {
            this.eventPublisher.publish((Object)new ConfigurationPropertyUpdatedEvent("validation.factors.include_ip_address", oldValue, newValue));
        }
    }

    public void removeProperty(String name) {
        this.propertyDAO.remove("crowd", name);
    }

    protected Property getPropertyObject(String name) throws ObjectNotFoundException {
        return this.propertyDAO.find("crowd", name);
    }

    public String getProperty(String name) throws ObjectNotFoundException {
        Property property = this.getPropertyObject(name);
        return property.getValue();
    }

    public void setProperty(String name, String value) {
        this.setProperty(name, value, true);
    }

    @VisibleForTesting
    void setProperty(String name, String value, boolean publishEvent) {
        String oldValue;
        Property property = null;
        try {
            property = this.getPropertyObject(name);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        if (property == null) {
            property = new Property("crowd", name, value);
            oldValue = null;
        } else {
            oldValue = property.getValue();
            property.setValue(value);
        }
        this.propertyDAO.update(property);
        String oldValueOrNull = Strings.emptyToNull((String)oldValue);
        String newValueOrNull = Strings.emptyToNull((String)value);
        if (publishEvent && !Objects.equals(oldValueOrNull, newValueOrNull)) {
            this.eventPublisher.publish((Object)new ConfigurationPropertyUpdatedEvent(name, oldValueOrNull, newValueOrNull));
        }
    }

    public String getString(String property, String defaultValue) {
        try {
            return this.getProperty(property);
        }
        catch (ObjectNotFoundException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String property, boolean defaultValue) {
        try {
            String value = this.getProperty(property);
            return Boolean.valueOf(value);
        }
        catch (ObjectNotFoundException e) {
            return defaultValue;
        }
    }

    public int getInt(String property, int defaultValue) {
        String value = null;
        try {
            value = this.getProperty(property);
            return Integer.parseInt(value);
        }
        catch (ObjectNotFoundException e) {
            return defaultValue;
        }
        catch (NumberFormatException e) {
            logger.warn("Corrupted value found for property {}. Found {} instead of an integer", (Object)property, (Object)value);
            return defaultValue;
        }
    }

    public void setBaseUrl(URI url) {
        Preconditions.checkArgument((boolean)url.isAbsolute(), (Object)"Base url needs to be absolute");
        this.setProperty("base.url", url.toString());
    }

    public URI getBaseUrl() throws PropertyManagerException {
        try {
            String property = this.getProperty("base.url");
            return new URI(property);
        }
        catch (ObjectNotFoundException | URISyntaxException e) {
            throw new PropertyManagerException("Base URL not configured correctly", e);
        }
    }
}

