/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationRoundInformation;
import com.atlassian.crowd.manager.directory.DirectorySynchronisationInformationStore;
import com.atlassian.crowd.model.directory.DirectorySynchronisationStatus;
import com.atlassian.crowd.model.directory.SynchronisationStatusKey;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DirectorySynchronisationInformationStoreImpl
implements DirectorySynchronisationInformationStore {
    private static final Logger log = LoggerFactory.getLogger(DirectorySynchronisationInformationStoreImpl.class);
    private final ConcurrentMap<Long, DirectorySynchronisationInformation> syncStatus;

    public DirectorySynchronisationInformationStoreImpl() {
        this(new ConcurrentHashMap<Long, DirectorySynchronisationInformation>());
    }

    public DirectorySynchronisationInformationStoreImpl(ConcurrentMap<Long, DirectorySynchronisationInformation> syncStatus) {
        this.syncStatus = syncStatus;
    }

    @Override
    public DirectorySynchronisationRoundInformation getActive(long directoryId) {
        return this.get(directoryId) != null ? this.get(directoryId).getActiveRound() : null;
    }

    @Override
    public Optional<DirectorySynchronisationRoundInformation> getLast(long directoryId) {
        return Optional.ofNullable(this.get(directoryId)).map(DirectorySynchronisationInformation::getLastRound);
    }

    @Override
    public void clear(long directoryId) {
        this.syncStatus.remove(directoryId);
    }

    @Override
    public void clear() {
        this.syncStatus.clear();
    }

    @Override
    public void syncStatus(long directoryId, String statusKey, List<Serializable> parameters) {
        DirectorySynchronisationInformation directorySynchronisationInformation = this.get(directoryId);
        DirectorySynchronisationRoundInformation activeRound = directorySynchronisationInformation.getActiveRound();
        if (activeRound != null) {
            this.syncStatus.put(directoryId, new DirectorySynchronisationInformation(directorySynchronisationInformation.getLastRound(), new DirectorySynchronisationRoundInformation(activeRound.getStartTime(), activeRound.getDurationMs(), statusKey, parameters)));
        } else {
            this.syncStatus.put(directoryId, new DirectorySynchronisationInformation(directorySynchronisationInformation.getLastRound(), new DirectorySynchronisationRoundInformation(System.currentTimeMillis(), -1L, statusKey, parameters)));
        }
    }

    @Override
    public void syncStatus(long directoryId, SynchronisationStatusKey statusKey, List<Serializable> parameters) {
        this.syncStatus(directoryId, statusKey.getI18Key(), parameters);
    }

    @Override
    public void syncStarted(long directoryId, long timestamp) {
        Optional<DirectorySynchronisationInformation> current = Optional.ofNullable(this.get(directoryId));
        this.syncStatus.put(directoryId, new DirectorySynchronisationInformation((DirectorySynchronisationRoundInformation)current.map(DirectorySynchronisationInformation::getLastRound).orElse(null), new DirectorySynchronisationRoundInformation(timestamp, -1L, SynchronisationStatusKey.STARTED.getI18Key(), Collections.emptyList())));
    }

    @Override
    public void syncFinished(long directoryId, long timestamp, SynchronisationStatusKey statusKey, List<Serializable> parameters) {
        DirectorySynchronisationRoundInformation current = this.get(directoryId).getActiveRound();
        if (current != null) {
            this.syncStatus.put(directoryId, new DirectorySynchronisationInformation(new DirectorySynchronisationRoundInformation(current.getStartTime(), timestamp - current.getStartTime(), statusKey.getI18Key(), parameters), null));
        } else {
            this.syncStatus.put(directoryId, new DirectorySynchronisationInformation(new DirectorySynchronisationRoundInformation(timestamp, timestamp, statusKey.getI18Key(), parameters), null));
        }
    }

    @Override
    public Collection<DirectorySynchronisationStatus> getStalledSynchronizations() {
        log.debug("Called non database implementation of getStalledSynchronizations - ignoring");
        return Collections.emptyList();
    }

    public DirectorySynchronisationInformation get(long directoryId) {
        return this.syncStatus.get(directoryId) != null ? (DirectorySynchronisationInformation)this.syncStatus.get(directoryId) : new DirectorySynchronisationInformation(null, null);
    }
}

