/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.permission;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public enum UserPermission {
    SYS_ADMIN(2);

    private static final Map<Integer, UserPermission> ID_TO_PERMISSION_MAP;
    private final int id;

    private UserPermission(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static Set<UserPermission> allPermissions() {
        return EnumSet.allOf(UserPermission.class);
    }

    @Nullable
    public static UserPermission fromId(int id) {
        return ID_TO_PERMISSION_MAP.get(id);
    }

    static {
        HashMap<Integer, UserPermission> map = new HashMap<Integer, UserPermission>();
        for (UserPermission permission : UserPermission.values()) {
            map.put(permission.getId(), permission);
        }
        ID_TO_PERMISSION_MAP = map;
    }
}

