/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.DirectoryEntities;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class DirectoryMembershipsIterable
implements Iterable<Membership> {
    private final RemoteDirectory remoteDirectory;
    private final Iterable<String> groupNames;
    private final Function<String, Membership> lookUpMembers = from -> {
        try {
            return this.get((String)from);
        }
        catch (OperationFailedException ofe) {
            throw new Membership.MembershipIterationException((Throwable)ofe);
        }
    };

    public DirectoryMembershipsIterable(RemoteDirectory remoteDirectory, Iterable<String> groupNames) {
        Objects.requireNonNull(remoteDirectory);
        Objects.requireNonNull(groupNames);
        this.remoteDirectory = remoteDirectory;
        this.groupNames = groupNames;
    }

    public DirectoryMembershipsIterable(RemoteDirectory remoteDirectory) throws OperationFailedException {
        Objects.requireNonNull(remoteDirectory);
        List<Group> groups = remoteDirectory.searchGroups(QueryBuilder.queryFor(Group.class, EntityDescriptor.group(GroupType.GROUP)).returningAtMost(-1));
        this.remoteDirectory = remoteDirectory;
        this.groupNames = DirectoryEntities.namesOf(groups);
    }

    @Override
    public Iterator<Membership> iterator() {
        final Iterator<String> groupNamesIterator = this.groupNames.iterator();
        return new Iterator<Membership>(){

            @Override
            public boolean hasNext() {
                return groupNamesIterator.hasNext();
            }

            @Override
            public Membership next() {
                String groupName = (String)groupNamesIterator.next();
                return DirectoryMembershipsIterable.this.lookUpMembers.apply(groupName);
            }
        };
    }

    private Membership get(final String groupName) throws OperationFailedException {
        Set<Object> childGroupNamesSet;
        List<String> userNames = this.remoteDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
        if (this.remoteDirectory.supportsNestedGroups()) {
            List<String> childGroupNames = this.remoteDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
            childGroupNamesSet = Collections.unmodifiableSet(new HashSet<String>(childGroupNames));
        } else {
            childGroupNamesSet = Collections.emptySet();
        }
        final Set<String> userNamesSet = Collections.unmodifiableSet(new HashSet<String>(userNames));
        return new Membership(){

            public String getGroupName() {
                return groupName;
            }

            public Set<String> getUserNames() {
                return userNamesSet;
            }

            public Set<String> getChildGroupNames() {
                return childGroupNamesSet;
            }
        };
    }
}

