/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.common.BaseBuilder;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.server.ServerBuilder;

public class SshBuilderHelper {
    private SshBuilderHelper() {
    }

    private static List<NamedFactory<Signature>> signatureFactories() {
        List defaultSignatureFactories = ClientBuilder.setUpDefaultSignatureFactories((boolean)false);
        defaultSignatureFactories.add(BuiltinSignatures.dsa);
        defaultSignatureFactories.add(BuiltinSignatures.rsa_cert);
        defaultSignatureFactories.add(BuiltinSignatures.dsa_cert);
        return defaultSignatureFactories;
    }

    private static List<KeyExchangeFactory> keyExchangeFactories(Function<DHFactory, KeyExchangeFactory> dh2Kex) {
        ArrayList<BuiltinDHFactories> dhFactories = new ArrayList<BuiltinDHFactories>(BaseBuilder.DEFAULT_KEX_PREFERENCE);
        dhFactories.add(BuiltinDHFactories.dhgex);
        dhFactories.add(BuiltinDHFactories.dhg14);
        dhFactories.add(BuiltinDHFactories.dhg1);
        return NamedFactory.setUpTransformedFactories((boolean)false, dhFactories, dh2Kex);
    }

    public static ClientBuilder newClientBuilder() {
        return (ClientBuilder)((ClientBuilder)ClientBuilder.builder().signatureFactories(SshBuilderHelper.signatureFactories())).keyExchangeFactories(SshBuilderHelper.keyExchangeFactories(ClientBuilder.DH2KEX));
    }

    public static ServerBuilder newServerBuilder() {
        return (ServerBuilder)ServerBuilder.builder().keyExchangeFactories(SshBuilderHelper.keyExchangeFactories(ServerBuilder.DH2KEX));
    }
}

