/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.plugins.ssh.BambooTrustedKeyServerKeyVerifier;
import com.atlassian.bamboo.plugins.ssh.SshBuilderHelper;
import com.atlassian.bamboo.plugins.ssh.SshClientAndServerFactory;
import com.atlassian.bamboo.utils.SystemProperty;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.SshServer;

public class DefaultSshClientAndServerFactory
implements SshClientAndServerFactory {
    public static final DefaultSshClientAndServerFactory INSTANCE = new DefaultSshClientAndServerFactory();
    private final ClientBuilder sshClientBuilder = SshBuilderHelper.newClientBuilder().hostConfigEntryResolver(HostConfigEntryResolver.EMPTY).serverKeyVerifier((ServerKeyVerifier)BambooTrustedKeyServerKeyVerifier.INSTANCE);
    private final ServerBuilder sshServerBuilder = SshBuilderHelper.newServerBuilder();
    private final long authTimeout = TimeUnit.MINUTES.toMillis(SystemProperty.SSH_PROXY_CLIENT_AUTH_TIMEOUT.getTypedValue());
    private final long idleTimeout = TimeUnit.MINUTES.toMillis(SystemProperty.SSH_PROXY_CLIENT_IDLE_TIMEOUT.getTypedValue());
    private final long readTimeout = TimeUnit.MINUTES.toMillis(SystemProperty.SSH_PROXY_SERVER_READ_TIMEOUT.getTypedValue());

    private DefaultSshClientAndServerFactory() {
    }

    @Override
    public SshClient createSshClient() {
        SshClient sshClient = (SshClient)this.sshClientBuilder.build();
        PropertyResolverUtils.updateProperty((PropertyResolver)sshClient, (String)CoreModuleProperties.AUTH_TIMEOUT.getName(), (long)this.authTimeout);
        PropertyResolverUtils.updateProperty((PropertyResolver)sshClient, (String)CoreModuleProperties.IDLE_TIMEOUT.getName(), (long)this.idleTimeout);
        PropertyResolverUtils.updateProperty((PropertyResolver)sshClient, (String)CoreModuleProperties.NIO2_READ_TIMEOUT.getName(), (long)this.readTimeout);
        return sshClient;
    }

    @Override
    public SshServer createSshServer() {
        SshServer server = (SshServer)this.sshServerBuilder.build();
        PropertyResolverUtils.updateProperty((PropertyResolver)server, (String)CoreModuleProperties.IDLE_TIMEOUT.getName(), (long)TimeUnit.MINUTES.toMillis(SystemProperty.SSH_PROXY_SERVER_IDLE_TIMEOUT.getTypedValue()));
        PropertyResolverUtils.updateProperty((PropertyResolver)server, (String)CoreModuleProperties.NIO2_READ_TIMEOUT.getName(), (long)TimeUnit.MINUTES.toMillis(SystemProperty.SSH_PROXY_SERVER_READ_TIMEOUT.getTypedValue()));
        return server;
    }
}

