/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.util.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class YamlFile {
    private static final AtomicLong COUNTER = new AtomicLong();
    private static final String YAML_FILE_PATTERN = "%05d-%08x-%s.yaml";
    private final Path location;
    private final int counter;
    private final int hashCode;
    private final String id;
    private static final Pattern CANONICALISING_REGEX = Pattern.compile(".*\\sspecsSourceId:\\s.*");

    private YamlFile(Path location, int counter, int hashCode, String id) {
        this.location = location;
        this.counter = counter;
        this.hashCode = hashCode;
        this.id = id;
    }

    public int getCounter() {
        return this.counter;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public String getId() {
        return this.id;
    }

    public Path getLocation() {
        return this.location;
    }

    public boolean contentCanonicallyEquals(YamlFile other) throws IOException {
        if (other.hashCode != this.hashCode) {
            return false;
        }
        String otherContent = FileUtils.readFileToString(other.location);
        String thisContent = FileUtils.readFileToString(this.location);
        return YamlFile.toCanonicalContent(otherContent).equals(YamlFile.toCanonicalContent(thisContent));
    }

    public static YamlFile parse(@NotNull Path path) {
        String name = path.getFileName().toString();
        String counter = name.substring(0, 5);
        String hashCode = name.substring(6, 14);
        String id = name.substring(15);
        if (id.endsWith(".yaml") || id.endsWith(".yml")) {
            id = id.substring(0, id.lastIndexOf(46));
        }
        int counterInt = Integer.parseInt(counter);
        int hashCodeInt = Integer.parseUnsignedInt(hashCode, 16);
        return new YamlFile(path, counterInt, hashCodeInt, id);
    }

    static String getFileName(@NotNull RootEntityPropertiesBuilder<?> entityProperties, String content) {
        return String.format(YAML_FILE_PATTERN, COUNTER.getAndIncrement(), YamlFile.getCanonicalContentHash(content), entityProperties.humanReadableId().replaceAll("\\W", "-"));
    }

    public static String generateFileName(@NotNull RootEntityPropertiesBuilder<?> entityProperties, String content, AtomicLong fileCounter) {
        return String.format(YAML_FILE_PATTERN, fileCounter.getAndIncrement(), YamlFile.getCanonicalContentHash(content), entityProperties.humanReadableId().replaceAll("\\W", "-"));
    }

    public static String generateFileName(@NotNull String humanReadableId, String content, AtomicLong fileCounter) {
        return String.format(YAML_FILE_PATTERN, fileCounter.getAndIncrement(), YamlFile.getCanonicalContentHash(content), humanReadableId.replaceAll("\\W", "-"));
    }

    private static int getCanonicalContentHash(String yaml) {
        return YamlFile.toCanonicalContent(yaml).hashCode();
    }

    private static String toCanonicalContent(String yaml) {
        return CANONICALISING_REGEX.matcher(yaml).replaceAll("");
    }
}

