/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.inspector.TagInspector;
import org.yaml.snakeyaml.nodes.Tag;

public class BambooSpecsTagInspector
implements TagInspector {
    private static final Set<Pattern> WHITELISTED_CLASSES = Collections.unmodifiableSet(new HashSet<Pattern>(){
        {
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.util\\.BambooSpecProperties"));
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.api\\.model\\..*Properties"));
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.api\\.model\\..*Properties\\$.+"));
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.model\\..*Properties"));
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.model\\..*Properties\\$.+"));
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.api\\.builders\\.Applicability"));
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.api\\.builders\\.permission\\.PermissionType"));
            this.add(Pattern.compile("java\\.time\\.Duration"));
        }
    });

    public boolean isGlobalTagAllowed(Tag tag) {
        String fullClassName = tag.getClassName();
        return WHITELISTED_CLASSES.stream().anyMatch(pattern -> pattern.matcher(fullClassName).matches());
    }
}

