/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class MsBuildTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugin.dotnet:msbuild");
    private static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"MsBuild task");
    private final String executable;
    private final String projectFile;
    private final String options;
    private final String environmentVariables;
    private final String workingSubdirectory;

    private MsBuildTaskProperties() {
        this.executable = null;
        this.projectFile = null;
        this.options = null;
        this.environmentVariables = null;
        this.workingSubdirectory = null;
    }

    public MsBuildTaskProperties(@Nullable String description, boolean enabled, @NotNull String executable, @NotNull String projectFile, @NotNull String options, @NotNull String environmentVariables, @NotNull String workingSubdirectory, @NotNull List<RequirementProperties> requirements, @NotNull List<? extends ConditionProperties> conditions) throws PropertiesValidationException {
        super(description, enabled, requirements, conditions);
        this.executable = executable;
        this.projectFile = projectFile;
        this.options = options;
        this.environmentVariables = environmentVariables;
        this.workingSubdirectory = workingSubdirectory;
        this.validate();
    }

    public void validate() {
        super.validate();
        ImporterUtils.checkThat((ValidationContext)VALIDATION_CONTEXT, (boolean)StringUtils.isNotBlank((CharSequence)this.executable), (String)"Executable is not defined", (Object[])new Object[0]);
        ImporterUtils.checkThat((ValidationContext)VALIDATION_CONTEXT, (boolean)StringUtils.isNotBlank((CharSequence)this.projectFile), (String)"Project file is not defined", (Object[])new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MsBuildTaskProperties)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MsBuildTaskProperties that = (MsBuildTaskProperties)((Object)o);
        return Objects.equals(this.getExecutable(), that.getExecutable()) && Objects.equals(this.getProjectFile(), that.getProjectFile()) && Objects.equals(this.getOptions(), that.getOptions()) && Objects.equals(this.getEnvironmentVariables(), that.getEnvironmentVariables()) && Objects.equals(this.getWorkingSubdirectory(), that.getWorkingSubdirectory());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getExecutable(), this.getProjectFile(), this.getOptions(), this.getEnvironmentVariables(), this.getWorkingSubdirectory());
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public String getExecutable() {
        return this.executable;
    }

    public String getProjectFile() {
        return this.projectFile;
    }

    public String getOptions() {
        return this.options;
    }

    public String getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public String getWorkingSubdirectory() {
        return this.workingSubdirectory;
    }
}

