/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ArtifactItemProperties
implements EntityProperties {
    @Nullable
    private final PlanIdentifierProperties sourcePlan;
    @Nullable
    private final String artifactName;
    private final boolean allArtifacts;

    private ArtifactItemProperties() {
        this.sourcePlan = null;
        this.artifactName = null;
        this.allArtifacts = false;
    }

    public ArtifactItemProperties(@Nullable PlanIdentifierProperties sourcePlan, boolean allArtifacts, @Nullable String artifactName) {
        this.sourcePlan = sourcePlan;
        this.artifactName = artifactName;
        this.allArtifacts = allArtifacts;
        this.validate();
    }

    @Nullable
    public PlanIdentifierProperties getSourcePlan() {
        return this.sourcePlan;
    }

    @Nullable
    public String getArtifactName() {
        return this.artifactName;
    }

    public boolean isAllArtifacts() {
        return this.allArtifacts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactItemProperties that = (ArtifactItemProperties)o;
        return this.allArtifacts == that.allArtifacts && Objects.equals(this.sourcePlan, that.sourcePlan) && Objects.equals(this.artifactName, that.artifactName);
    }

    public int hashCode() {
        return Objects.hash(this.sourcePlan, this.artifactName, this.allArtifacts);
    }

    public void validate() {
        ValidationContext context = ValidationContext.of((String)"SCP task").with("Artifact");
        ImporterUtils.checkThat((ValidationContext)context.with("Artifact name"), (this.allArtifacts || this.artifactName != null ? 1 : 0) != 0, (String)"Artifact name is required unless all artifacts are selected. You have name=%s and all artifacts=%b", (Object[])new Object[]{this.artifactName, this.allArtifacts});
    }
}

