/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.plan;

import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.label.EmptyLabelsListProperties;
import com.atlassian.bamboo.specs.api.model.label.LabelProperties;
import com.atlassian.bamboo.specs.codegen.emitters.CodeGenerationUtils;
import com.atlassian.bamboo.specs.codegen.emitters.value.ValueEmitterFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public class PlanLabelsEmitter
implements CodeEmitter<Iterable<LabelProperties>> {
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull Iterable<LabelProperties> value) throws CodeGenerationException {
        List labelProperties = StreamSupport.stream(value.spliterator(), false).collect(Collectors.toList());
        if (labelProperties.size() == 1 && labelProperties.get(0) instanceof EmptyLabelsListProperties) {
            return ".noLabels()";
        }
        StringBuilder result = new StringBuilder(".labels(");
        ArrayList<String> valuesAndFails = new ArrayList<String>();
        HashSet<Integer> failed = new HashSet<Integer>();
        int count = 0;
        for (LabelProperties labelProperty : labelProperties) {
            String label = labelProperty.getName();
            try {
                CodeEmitter<String> emitter = ValueEmitterFactory.emitterFor(label);
                String code = emitter.emitCode(context, (Object)label);
                valuesAndFails.add(code);
            }
            catch (CodeGenerationException e) {
                valuesAndFails.add(e.getMessage());
                failed.add(count);
            }
            ++count;
        }
        context.incIndentation();
        CodeGenerationUtils.appendCommaSeparatedList(context, result, valuesAndFails, failed);
        context.decIndentation();
        return result.append(")").toString();
    }
}

