/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.docker;

import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.docker.DockerConfigurationProperties;
import com.atlassian.bamboo.specs.codegen.emitters.fragment.FieldSetterEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.value.LiteralEmitter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DockerConfigurationVolumesEmitter
extends FieldSetterEmitter<Map<String, String>> {
    public DockerConfigurationVolumesEmitter() {
        super("volume");
    }

    @Override
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull Map<String, String> volumes) throws CodeGenerationException {
        ArrayList<String> clauses = new ArrayList<String>();
        LiteralEmitter literalEmitter = new LiteralEmitter();
        LinkedHashMap<String, String> volumesToEmit = new LinkedHashMap<String, String>(volumes);
        Map defaultVolumes = DockerConfigurationProperties.DEFAULT_VOLUMES;
        boolean defaultsVolumesUsed = volumes.entrySet().containsAll(defaultVolumes.entrySet());
        if (defaultsVolumesUsed) {
            volumesToEmit.keySet().removeAll(defaultVolumes.keySet());
        } else {
            clauses.add(".withoutDefaultVolumes()");
        }
        for (Map.Entry e : volumesToEmit.entrySet()) {
            clauses.add(String.format(".volume(%s, %s)", literalEmitter.emitCode(context, e.getKey()), literalEmitter.emitCode(context, e.getValue())));
        }
        return clauses.stream().collect(Collectors.joining(context.newLine()));
    }
}

