/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.model.task.ScriptTaskProperties;
import com.atlassian.bamboo.specs.util.FileUtils;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptTask
extends Task<ScriptTask, ScriptTaskProperties> {
    private ScriptTaskProperties.Interpreter interpreter = ScriptTaskProperties.Interpreter.SHELL;
    private ScriptTaskProperties.Location location = ScriptTaskProperties.Location.INLINE;
    @Nullable
    private String body;
    @Nullable
    private String path;
    @Nullable
    private String argument;
    @Nullable
    private String environmentVariables;
    @Nullable
    private String workingSubdirectory;

    private void inline() {
        this.location = ScriptTaskProperties.Location.INLINE;
        this.path = null;
    }

    private void file() {
        this.location = ScriptTaskProperties.Location.FILE;
        this.body = null;
    }

    public ScriptTask location(ScriptTaskProperties.Location location) {
        this.location = location;
        return this;
    }

    public ScriptTask interpreterShell() {
        return this.interpreter(ScriptTaskProperties.Interpreter.SHELL);
    }

    public ScriptTask interpreterWindowsPowerShell() {
        return this.interpreter(ScriptTaskProperties.Interpreter.WINDOWS_POWER_SHELL);
    }

    public ScriptTask interpreterBinSh() {
        return this.interpreter(ScriptTaskProperties.Interpreter.BINSH_OR_CMDEXE);
    }

    public ScriptTask interpreterCmdExe() {
        return this.interpreter(ScriptTaskProperties.Interpreter.BINSH_OR_CMDEXE);
    }

    public ScriptTask interpreter(ScriptTaskProperties.Interpreter interpreter) {
        this.interpreter = interpreter;
        return this;
    }

    public ScriptTask inlineBody(@NotNull String body) {
        ImporterUtils.checkNotEmpty((String)"script inline body", (String)body);
        this.inline();
        this.body = body;
        return this;
    }

    public ScriptTask inlineBodyFromPath(@NotNull Path path) {
        this.body = FileUtils.readFileContent(path, "script inline file", "Error when reading script body from path: %s");
        return this;
    }

    public ScriptTask fileFromPath(@NotNull Path path) {
        ImporterUtils.checkNotNull((String)"script file path", (Object)path);
        return this.fileFromPath(path.toString());
    }

    public ScriptTask fileFromPath(@NotNull String path) {
        ImporterUtils.checkNotEmpty((String)"script file path", (String)path);
        this.file();
        this.path = path;
        return this;
    }

    public ScriptTask argument(@NotNull String argument) {
        ImporterUtils.checkNotEmpty((String)"argument", (String)argument);
        this.argument = argument;
        return this;
    }

    public ScriptTask environmentVariables(@NotNull String environmentVariables) {
        ImporterUtils.checkNotEmpty((String)"environment variables", (String)environmentVariables);
        this.environmentVariables = environmentVariables;
        return this;
    }

    public ScriptTask workingSubdirectory(@NotNull String workingSubdirectory) {
        ImporterUtils.checkNotEmpty((String)"working subdirectory", (String)workingSubdirectory);
        this.workingSubdirectory = workingSubdirectory;
        return this;
    }

    @NotNull
    protected ScriptTaskProperties build() {
        return new ScriptTaskProperties(this.description, this.taskEnabled, this.interpreter, this.location, this.body, this.path, this.argument, this.environmentVariables, this.workingSubdirectory, this.requirements, this.conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScriptTask)) {
            return false;
        }
        ScriptTask that = (ScriptTask)((Object)o);
        return this.interpreter == that.interpreter && this.location == that.location && Objects.equals(this.body, that.body) && Objects.equals(this.path, that.path) && Objects.equals(this.argument, that.argument) && Objects.equals(this.environmentVariables, that.environmentVariables) && Objects.equals(this.workingSubdirectory, that.workingSubdirectory);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interpreter, this.location, this.body, this.path, this.argument, this.environmentVariables, this.workingSubdirectory});
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("interpreter", (Object)this.interpreter).append("location", (Object)this.location).append("body", (Object)this.body).append("path", (Object)this.path).append("argument", (Object)this.argument).append("environmentVariables", (Object)this.environmentVariables).append("workingSubdirectory", (Object)this.workingSubdirectory).toString();
    }
}

