/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.model.task.BaseSshTaskProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSshTask<T extends BaseSshTask<T, E>, E extends BaseSshTaskProperties>
extends Task<T, E> {
    protected List<String> hosts = new ArrayList<String>();
    protected String username;
    protected BaseSshTaskProperties.AuthenticationType authenticationType;
    @Nullable
    protected String password;
    @Nullable
    protected String key;
    @Nullable
    protected String passphrase;
    @Nullable
    protected String hostFingerprint;
    protected int port = BaseSshTaskProperties.DEFAULT_PORT;
    @Nullable
    protected SharedCredentialsIdentifierProperties sharedCredentials;

    public T host(@NotNull String host) {
        ImporterUtils.checkNotEmpty((String)"host", (String)host);
        this.hosts.add(host);
        return (T)((Object)this);
    }

    public T host(String ... host) {
        List<String> hosts = Arrays.asList(host);
        hosts.forEach(h -> ImporterUtils.checkNotEmpty((String)"host", (String)h));
        this.hosts.addAll(hosts);
        return (T)((Object)this);
    }

    public T username(@NotNull String username) {
        ImporterUtils.checkNotEmpty((String)"username", (String)username);
        this.username = username;
        return (T)((Object)this);
    }

    public T authenticateWithPassword(@NotNull String password) {
        ImporterUtils.checkNotEmpty((String)"password", (String)password);
        this.authenticationType = BaseSshTaskProperties.AuthenticationType.PASSWORD;
        this.password = password;
        return (T)((Object)this);
    }

    public T authenticateWithKeyWithPassphrase(@NotNull String key, @NotNull String passphrase) {
        ImporterUtils.checkNotEmpty((String)"key", (String)key);
        ImporterUtils.checkNotEmpty((String)"passphrase", (String)passphrase);
        this.authenticationType = BaseSshTaskProperties.AuthenticationType.KEY_WITH_PASSPHRASE;
        this.key = key;
        this.passphrase = passphrase;
        return (T)((Object)this);
    }

    public T authenticateWithKeyWithPassphrase(@NotNull Path keyPath, @NotNull String passphrase) {
        ImporterUtils.checkNotNull((String)"key path", (Object)keyPath);
        return this.authenticateWithKeyWithPassphrase(BaseSshTask.keyFromPath(keyPath), passphrase);
    }

    public T authenticateWithKey(@NotNull String key) {
        ImporterUtils.checkNotEmpty((String)"key", (String)key);
        this.authenticationType = BaseSshTaskProperties.AuthenticationType.KEY_WITHOUT_PASSPHRASE;
        this.key = key;
        return (T)((Object)this);
    }

    public T authenticateWithKey(@NotNull Path keyPath) {
        ImporterUtils.checkNotNull((String)"key path", (Object)keyPath);
        return this.authenticateWithKey(BaseSshTask.keyFromPath(keyPath));
    }

    public T authenticateWithSshSharedCredentials(@NotNull SharedCredentialsIdentifier sharedCredentials) {
        ImporterUtils.checkNotNull((String)"shared credentials", (Object)sharedCredentials);
        this.sharedCredentials = (SharedCredentialsIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)sharedCredentials);
        this.authenticationType = BaseSshTaskProperties.AuthenticationType.KEY_WITH_PASSPHRASE;
        return (T)((Object)this);
    }

    public T authenticateWithUsernamePasswordSharedCredentials(@NotNull SharedCredentialsIdentifier sharedCredentials) {
        ImporterUtils.checkNotNull((String)"shared credentials", (Object)sharedCredentials);
        this.sharedCredentials = (SharedCredentialsIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)sharedCredentials);
        this.authenticationType = BaseSshTaskProperties.AuthenticationType.PASSWORD;
        return (T)((Object)this);
    }

    private static String keyFromPath(@NotNull Path keyPath) throws PropertiesValidationException {
        File file = keyPath.toFile();
        if (!file.exists()) {
            throw new PropertiesValidationException(String.format("File %s does not exist", file.getAbsolutePath()));
        }
        try {
            return new String(Files.readAllBytes(keyPath));
        }
        catch (IOException e) {
            throw new PropertiesValidationException(String.format("Error when key from path: %s", file.getAbsolutePath()), (Throwable)e);
        }
    }

    public T hostFingerprint(@NotNull String hostFingerprint) {
        ImporterUtils.checkNotEmpty((String)"host fingerprint", (String)hostFingerprint);
        this.hostFingerprint = hostFingerprint;
        return (T)((Object)this);
    }

    public T port(int port) {
        ImporterUtils.checkNotNegative((String)"port", (int)port);
        this.port = port;
        return (T)((Object)this);
    }

    public T portDefault() {
        this.port(22);
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseSshTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseSshTask that = (BaseSshTask)((Object)o);
        return this.port == that.port && Objects.equals(this.hosts, that.hosts) && Objects.equals(this.username, that.username) && this.authenticationType == that.authenticationType && Objects.equals(this.password, that.password) && Objects.equals(this.key, that.key) && Objects.equals(this.passphrase, that.passphrase) && Objects.equals(this.hostFingerprint, that.hostFingerprint) && Objects.equals(this.sharedCredentials, that.sharedCredentials);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.hosts, this.username, this.authenticationType, this.password, this.key, this.passphrase, this.hostFingerprint, this.port, this.sharedCredentials});
    }
}

