/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.codegen.annotations.Setter;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.task.BuildWarningParserTask;
import com.atlassian.bamboo.specs.codegen.emitters.task.BuildWarningParserTaskEmitter;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CodeGenerator(value=BuildWarningParserTaskEmitter.class)
public class BuildWarningParserTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties MODULE_PROPERTIES = new AtlassianModuleProperties("com.atlassian.bamboo.warnings.atlassian-bamboo-warnings:task.warnings.parser");
    private final String parser;
    @Setter(value="parseFiles")
    @Nullable
    private final String filePattern;
    private final boolean associateWithRepository;
    private final boolean defaultRepository;
    @Nullable
    private final VcsRepositoryIdentifierProperties repository;
    private final boolean failBuild;
    private final int failBuildThreshold;
    private final BuildWarningParserTask.WarningSeverity failBuildSeverity;

    private BuildWarningParserTaskProperties() {
        this.parser = null;
        this.filePattern = null;
        this.associateWithRepository = false;
        this.defaultRepository = false;
        this.repository = null;
        this.failBuild = false;
        this.failBuildThreshold = 0;
        this.failBuildSeverity = BuildWarningParserTask.WarningSeverity.LOW;
    }

    public BuildWarningParserTaskProperties(String description, boolean enabled, @NotNull List<RequirementProperties> requirements, @NotNull List<? extends ConditionProperties> conditions, @NotNull String parser, @Nullable String filePattern, boolean associateWithRepository, boolean defaultRepository, @Nullable VcsRepositoryIdentifierProperties repository, boolean failBuild, int failBuildThreshold, @NotNull BuildWarningParserTask.WarningSeverity failBuildSeverity) throws PropertiesValidationException {
        super(description, enabled, requirements, conditions);
        this.parser = parser;
        this.filePattern = filePattern;
        this.associateWithRepository = associateWithRepository;
        this.defaultRepository = defaultRepository;
        this.repository = repository;
        this.failBuild = failBuild;
        this.failBuildThreshold = failBuildThreshold;
        this.failBuildSeverity = failBuildSeverity;
        this.validate();
    }

    public String getParser() {
        return this.parser;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public boolean isAssociateWithRepository() {
        return this.associateWithRepository;
    }

    public boolean isDefaultRepository() {
        return this.defaultRepository;
    }

    @Nullable
    public VcsRepositoryIdentifierProperties getRepository() {
        return this.repository;
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public int getFailBuildThreshold() {
        return this.failBuildThreshold;
    }

    public BuildWarningParserTask.WarningSeverity getFailBuildSeverity() {
        return this.failBuildSeverity;
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return MODULE_PROPERTIES;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildWarningParserTaskProperties that = (BuildWarningParserTaskProperties)((Object)o);
        return this.isAssociateWithRepository() == that.isAssociateWithRepository() && this.isDefaultRepository() == that.isDefaultRepository() && this.isFailBuild() == that.isFailBuild() && this.getFailBuildThreshold() == that.getFailBuildThreshold() && Objects.equals(this.getParser(), that.getParser()) && Objects.equals(this.getFilePattern(), that.getFilePattern()) && Objects.equals(this.getRepository(), that.getRepository()) && this.getFailBuildSeverity() == that.getFailBuildSeverity();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getParser(), this.getFilePattern(), this.isAssociateWithRepository(), this.isDefaultRepository(), this.getRepository(), this.isFailBuild(), this.getFailBuildThreshold(), this.getFailBuildSeverity()});
    }

    public void validate() {
        ValidationContext context = ValidationContext.of((String)"Build warning parser task");
        if (this.isAssociateWithRepository()) {
            ImporterUtils.checkThat((ValidationContext)context.with("repository"), (this.defaultRepository || this.repository != null ? 1 : 0) != 0, (String)"Repository to associate with has to be defined", (Object[])new Object[0]);
        }
        if (this.isFailBuild()) {
            ImporterUtils.checkThat((ValidationContext)context.with("failBuildThreshold"), (this.getFailBuildThreshold() >= 0 ? 1 : 0) != 0, (String)"Fail build threshold must not be negative", (Object[])new Object[0]);
            ImporterUtils.checkThat((ValidationContext)context.with("failBuildSeverity"), (this.getFailBuildSeverity() != null ? 1 : 0) != 0, (String)"Relevant severity undefined", (Object[])new Object[0]);
        }
        ImporterUtils.checkThat((ValidationContext)context.with("parser"), (boolean)StringUtils.isNotBlank((CharSequence)this.parser), (String)"Parser undefined", (Object[])new Object[0]);
        super.validate();
    }
}

