/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.repository.bitbucket.cloud;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@ConstructFrom(value={"email"})
@Immutable
public class EmailApiTokenAuthenticationProperties
implements AuthenticationProperties {
    private final String email;
    private final String apiToken;

    private EmailApiTokenAuthenticationProperties() {
        this.email = null;
        this.apiToken = null;
    }

    public EmailApiTokenAuthenticationProperties(String email, String apiToken) {
        this.email = email;
        this.apiToken = apiToken;
        this.validate();
    }

    public String getEmail() {
        return this.email;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public void validate() {
        ImporterUtils.checkNotNull((String)"email", (Object)this.email);
        ValidationContext context = ValidationContext.of((String)"User-token authentication");
        ArrayList errors = new ArrayList();
        if (!ValidationUtils.containsBambooVariable((String)this.email)) {
            ValidationUtils.validateNotContainsRelaxedXssRelatedCharacters((ValidationContext)context.with("email"), (String)this.email).ifPresent(errors::add);
        }
        ImporterUtils.checkNoErrors(errors);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailApiTokenAuthenticationProperties that = (EmailApiTokenAuthenticationProperties)o;
        return Objects.equals(this.email, that.email) && Objects.equals(this.apiToken, that.apiToken);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.apiToken);
    }
}

