/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.notification;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationRecipientProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@ConstructFrom(value={"webhookName", "url"})
@Immutable
public class WebhookRecipientProperties
extends NotificationRecipientProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugin.system.notifications:recipient.webhook");
    private final String webhookName;
    private final String url;

    private WebhookRecipientProperties() {
        this.webhookName = null;
        this.url = null;
    }

    public WebhookRecipientProperties(@NotNull String webhookName, @NotNull String url) {
        this.webhookName = webhookName;
        this.url = url;
        this.validate();
    }

    public String getWebhookName() {
        return this.webhookName;
    }

    public String getUrl() {
        return this.url;
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public void validate() {
        ValidationContext context = ValidationContext.of((String)"webhookRecipient");
        ImporterUtils.checkNotBlank((ValidationContext)context, (String)"webhookName", (String)this.webhookName);
        ImporterUtils.checkNotBlank((ValidationContext)context, (String)"url", (String)this.url);
        try {
            new URL(this.url);
        }
        catch (MalformedURLException e) {
            throw new PropertiesValidationException(context, String.format("Argument %s is not valid URL", this.url));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WebhookRecipientProperties that = (WebhookRecipientProperties)((Object)o);
        if (this.webhookName != null ? !this.webhookName.equals(that.webhookName) : that.webhookName != null) {
            return false;
        }
        return this.url != null ? this.url.equals(that.url) : that.url == null;
    }

    public int hashCode() {
        int result = this.webhookName != null ? this.webhookName.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }
}

